// ==UserScript==
// @include http://*ogame*/game/*
// @name SuperOgame - Core file
// @author Mladen Pejaković
// @namespace http://superogame.890m.com/
// @version 1.5.2
// @description SuperOgame is an user javascript for Opera which improves experience of playing OGame
// ==/UserScript==

/* Copyright (C) 2008 Mladen Pejaković
 * based on original code by cedricpc
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 */

var RegEx  = /http:\/\/(.*?ogame.*?)\/game\/(.*?)$/i;
var Result = RegEx.exec(document.location);
var soGen_LTimeS = new Date();
var Server = Result[1];
var Page = Result[2].match(/page=(.*?)(?=&|$)/i) ? RegExp.$1 : '';
var Mode = Result[2].match(/mode=(.*?)(?=&|$)/i) ? RegExp.$1 : '';
var soVer_Curr = '1.5.2';

//### STORING ###

function soGetCookie(cName){
cName = '' + escape(cName) + '=';
if ((cPos = document.cookie.indexOf(cName)) != -1){
valuePos = cPos + cName.length;
valueEnd = document.cookie.indexOf(';', valuePos);
if (valueEnd == -1) valueEnd = document.cookie.length;
return unescape(document.cookie.substring(valuePos, valueEnd));}}

function soSetCookie(cName, cValue, cStck){
domain = ''; path   = '/';
expire = '; expires=' + (cStck ? new Date(new Date().getTime() +  3600000 * 24 * 7200).toGMTString() : -1);
document.cookie = '' + escape(cName) + '=' + escape(cValue) + '; path=' + path + expire + domain + ';';}

//### LANGUAGE ###

function sofGen_GetLang(){
var gServArr = new Array('ba','bg','cn','cz','de','dk','es','fi','fr','gr','hu','it','jp','kr','lt','lv','nl','no','pl','pt','ro','ru','sk','se','tr','tw');
for (var i = 26; i>=0; i--){
if(Server.match(gServArr[i])){gServer = gServArr[i];gLang = (soSet['soLan_Ovr'] == '' ? gServArr[i].toUpperCase() : soSet['soLan_Ovr']);break;}
else{gServer = 'en';gLang = 'EN';}}
switch (gServArr){
case 'br':
gLang = 'PT';}
var gServLan = gServer + ';' + gLang;
return gServLan.split(';');}

soLan_LngList = new Array();
soLan_LngList['EN'] = 'English';

function addLng(tagLng, nameLng){
soLan_LngList[tagLng.toUpperCase()] = nameLng;}

function i18n(w,n){
var lang = sofGen_GetLang();
var langa = (typeof(window['i18n_'+lang[1]]) == 'undefined' ? new Array() : window['i18n_'+lang[1]]);
return (lang != '' ? ((typeof(langa[n]) == 'undefined' || langa[n] == '') ? w : langa[n]) : w);}

//### REFRESH ###

function sofGen_AddRefr(functionName, interval){
var cpu_refr_fact = soSet['soRfr_Fact']
if (typeof(soGen_Refr) != 'object')
soGen_Refr = new Array();
soGen_Refr[functionName] = (isNaN(parseInt(interval)) ? 100 : parseInt(interval));
if (typeof(soGen_RefrTmr) == 'undefined')
soGen_RefrTmr = window.setInterval('soGen_RefrFunc()', 100);}

function sofGen_DelRefr(functionName){
if (soGen_Refr[functionName]) soGen_Refr[functionName] = 0;}

function soGen_RefrFunc(){
if (typeof(soGen_Refr) != 'object') return;
for (var functionName in soGen_Refr) {
var functionInterval = String(soGen_Refr[functionName]).split(';');
var interval = parseInt(functionInterval[0]);
var nextInterval = (functionInterval.length > 1 ? parseInt(functionInterval[1]) : 0);
if ((interval != 0) && (nextInterval <= 100))
eval(functionName + '()');
if (interval != 0)
soGen_Refr[functionName] = interval + ';' + (nextInterval <= 100 ? interval : nextInterval - 100);}}

//### SYSTEM ###

function xpath(path){
var xpathR = document.evaluate(path,document,null,XPathResult.FIRST_ORDERED_NODE_TYPE,null);
return xpathR.singleNodeValue;}

function xpaths(path){
var xpathsR = document.evaluate(path,document,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null);
return xpathsR;}

function AddCommas(number){
var number = String(parseInt(number));
return number.replace(/(\d{1,2}(\.\d{3})*)(?=(\d{3})+$)/g, '$1.');}

function DelCommas(number){
var number = parseInt(number.replace(/(\.|\s)/g, ''));
return (isNaN(number) ? 0 : number);}

function makeEvent(functionName){
document.addEventListener('DOMContentLoaded', functionName, false);}

function parseDate(oDate, format, local){
var defaultFormat = soSet['soGen_globTimeF'];
if ((typeof(format) == 'undefined') || (format == ''))
format = defaultFormat;
if (typeof(oDate.getSeconds()) == 'undefined')
return '';
if ((soSet['soGen_TimeDiff']) && (local != 1)) oDate = new Date(oDate.getTime() + (parseInt(soSet['soGen_TimeDiff']*3600*1000)));
var today = new Date();
var yearf = String(oDate.getFullYear());
var years = yearf.substr(yearf.length - 2, 2);
var month = (oDate.getMonth() < 9 ? '0' : '') + (oDate.getMonth() + 1);
var day = (oDate.getDate() <= 9 ? '0' : '') + oDate.getDate();
var hours = (oDate.getHours() <= 9 ? '0' : '') + oDate.getHours();
var minutes = (oDate.getMinutes() <= 9 ? '0' : '') + oDate.getMinutes();
var seconds = (oDate.getSeconds() <= 9 ? '0' : '') + oDate.getSeconds();
// format = format.replace(/(^|[^%])%(h|m)(\+|-)[0-9]+(.*?)/i, '$1$4');
format = format.replace(/(^|[^%])%\((.*?)\)/g, (oDate.getDate() == today.getDate() ? '$1' : '$1$2'));
format = format.replace(/(^|[^%])%Y/g, '$1' + yearf).replace(/(^|[^%])%y/g, '$1' + years);
format = format.replace(/(^|[^%])%m/gi, '$1' + month).replace(/(^|[^%])%d/gi, '$1' + day);
format = format.replace(/(^|[^%])%h/gi, '$1' + hours).replace(/(^|[^%])%n/gi, '$1' + minutes);
format = format.replace(/(^|[^%])%s/gi, '$1' + seconds).replace(/%%/g, '%');
return format;}

function sofSys_GetRes(){
var Metal = parseInt(xpath('//td[@align="center"][@class="header"][@width="90"][1]/font').innerHTML.replace(/\./g, ''));
var Crystal = parseInt(xpath('//td[@align="center"][@class="header"][@width="90"][2]/font').innerHTML.replace(/\./g, ''));
var Deuterium = parseInt(xpath('//td[@align="center"][@class="header"][@width="90"][3]/font').innerHTML.replace(/\./g, ''));
var Energy = xpath('//td[@align="center"][@class="header"][@width="90"][5]').innerHTML.split('/');
var Energy2 = parseInt(Energy[0].replace(/<.*?>/g, '').replace(/\./g, ''));
var Energy1 = parseInt(Energy[2].replace(/\./g, ''));
var Result = Metal + ';' + Crystal + ';' + Deuterium + ';' + Energy1 + ';' + Energy2;
return ((Result != 'undefined') ? Result.split(';') : -1);}

function sofSys_GetResName(){
var MetalName = xpath('//td[@align="center"][@class="header"][@width="85"][1]/i/b/font').innerHTML;
var CrystalName = xpath('//td[@align="center"][@class="header"][@width="85"][2]/i/b/font').innerHTML;
var DeuteriumName = xpath('//td[@align="center"][@class="header"][@width="85"][3]/i/b/font').innerHTML;
var EnergyName = xpath('//td[@align="center"][@class="header"][@width="85"][5]/i/b/font').innerHTML;
var Result = MetalName + ';' + CrystalName + ';' + DeuteriumName + ';' + EnergyName;
return ((Result != 'undefined') ? Result.split(';') : -1);}

function sofSys_GetSkinURL(){
if (typeof(soGen_SkinURL) != 'undefined') return soGen_SkinURL;
var skin = xpath('//head/link[4]');
soGen_SkinURL = skin.getAttribute('href').substr(0, skin.getAttribute('href').lastIndexOf('/'));
return soGen_SkinURL;}

function sofSys_GetTime(){
var thTime = xpath('//body/div[starts-with(@id,"content")]/center/table[@width="519"]/tbody/tr/th[@colspan="3"][1]');
var ServerTime = new Date(thTime.innerHTML);
var LocalTime  = new Date();
var ServerSeconds = (ServerTime - LocalTime);
soSetCookie('soSet_ServSecs', ServerSeconds);
soSet_ServSecs = ServerSeconds;}

function sofSys_ServSecs(){
if (typeof(soSet_ServSecs) == 'undefined'){
soSet_ServSecs = soGetCookie('soSet_ServSecs');}
return parseInt(((isNaN(soSet_ServSecs)) || (soSet_ServSecs == '') ? 0 : soSet_ServSecs));}

function sofSys_PlntCrds(){
var planetsList = new Array();
var options = xpath('//select[starts-with(@onchange,"haha(this)")]');
for (var i = 0, option = ''; option = options[i]; i++){
var planetID = option.value.match(/cp=(.*?)(?=&|$)/i) ? RegExp.$1 : '';
var planetName   = option.text;
var planetSelect = option.selected ? 1 : 0;
planetsList.push(planetID + '==' + planetName + '==' + planetSelect);}
planet_sets = planetsList.join('||');
soSetCookie('soSet_Planets', planet_sets);}

function sofUpd_PlntCrds(cPID){
var planets = soGetCookie('soSet_Planets');
if (planets == '') return;
var newPlanetsList = new Array();
var planetsList = planets.split('||');
for (var i = 0, planet = ''; planet = planetsList[i]; i++) {
planet = planet.split('==');
planetID = planet[0];
planetName = planet[1];
planetSelect = (planetID == cPID ? 1 : 0);
newPlanetsList.push(planetID + '==' + planetName + '==' + planetSelect);
new_planet_sets = newPlanetsList.join('||');}
soSetCookie('soSet_Planets', new_planet_sets);}

function sofSys_AMI(mlnkn, mlnkh, mlnkc, mlnkt){
var tble = xpath('//table[@width="110"]/tbody/tr[@id="soLnks"]');
mtr = document.createElement('tr');
mtr.innerHTML = '<td align="center"><a href="'+mlnkh+'" title="'+mlnkn+'" target="'+mlnkt+'"><span style="color:'+mlnkc+'">'+mlnkn+'</span></a></td>';
tble.parentNode.insertBefore(mtr,tble.nextSibling);}

function soSys_Checker(){
document.getElementById('soUpdater').innerHTML = i18n('Checking',58)+'...';
var updscript = document.createElement('script');
updscript.type = 'text/javascript';
updscript.src = 'http://superogame.890m.com/superogame/socheck.js';
document.body.appendChild(updscript);}

function sofSys_Opt(){
tbl = xpath('//div[@id="content"]/center/table[@width="519"]');
var ntbl = document.createElement('table');
ntbl.setAttribute('width','519');
var lang = sofGen_GetLang();
var langs = Array('UA','TW','TR','SE','SK','RU','RO','PT','PL','NO','NL','LV','LT','KR','JP','IT','HU','GR','FR','FI','ES','DK','DE','CZ','CN','BG','BA','EN');
var opts;
for (var i = langs.length-1; i >= 0; i--){var option = '<option value="'+langs[i]+'">'+soLan_LngList[langs[i]]+'</option>';
if(typeof(soLan_LngList[langs[i]]) == 'undefined') option = '';opts += option;}
ntbl.innerHTML = '<tr><td class="c" colspan="2">SuperOgame</td></tr><tr><th width="30%">'+i18n('Status',42)+'</th><th>'+(soSet['soSet_OnOff'] > 0 ? '<a style="cursor:hand;color:lime" title="'+i18n('Deactivate',48)+' SuperOgame" onclick="soSetCookie(\'soSet_OnOff\',0,true);location.reload()"><b>'+i18n('Activated',43)+'</b></a>' : '<a style="cursor:hand;color:red" title="'+i18n('Activate',47)+' SuperOgame" onclick="soSetCookie(\'soSet_OnOff\',1,true);location.reload()"><b>'+i18n('Deactivated',44)+'</b></a>')+'</th></tr><tr><th>'+i18n('Version',49)+'</th><th><b>'+soVer_Curr+'</b> (<span id="soUpdater" style="font-size:smaller;font-weight:bold;color:yellow"><a href="javascript: soSys_Checker();" style="color:yellow">'+i18n('Check for updates',57)+'</a></span>)</th></tr><tr><th>'+i18n('Links',46)+'</th><th style="text-align:left;text-indent:3px"><ul><li><a href="http://superogame.890m.com" target="_blank">'+i18n('Visit SuperOgame website',50)+'</a></li><li><a href="http://superogame.890m.com/forum" target="_blank">'+i18n('Visit SuperOgame forum',51)+'</a></li></ul></th></tr><tr><th>'+i18n('Language',45)+'</th><th><select onchange="soSetCookie(\'soLan_Ovr\',this.options[this.selectedIndex].value,true);location.reload()"><option value="" style="color:orange">'+(typeof(soLan_LngList[lang[1]]) == 'undefined' ? 'English' : soLan_LngList[lang[1]])+'</option><option value="">Default</option>'+opts+'</select></th></tr>';
tbl.parentNode.insertBefore(ntbl,tbl);
(soSet['soGen_VerCh'] ? soSys_Checker() : '')}

function sofSys_overlibFix(){window.opera.defineMagicVariable('olOp',function(){return true;},null);}

//### GENERAL ###

function sofGen_Men(){
var tblsoc = xpath('//div[@id="menu"]/p');
tblsoc.innerHTML += '<br /><nobr><span id="GlobalClock" title="'+(soSet['soGen_ClockI'] ? '' : sofSys_ServSecs()/1000+' [s]')+'" style="color:'+(soSet['soGen_ClockI'] ? soSet['soMen_ClockC'] : soSet['soGen_ClockC'])+';font-weight:bold"></span></nobr>';sofUpd_GlobClock();
sofGen_AddRefr('sofUpd_GlobClock',500);}

function sofUpd_GlobClock(){
var globTime = (soSet['soGen_ClockI'] ? new Date(new Date().getTime()) : new Date(new Date().getTime() + sofSys_ServSecs()));
if (globT = document.getElementById('GlobalClock'))
globT.innerHTML = parseDate(globTime, soSet['soGen_ClockF'], (soSet['soGen_ClockI'] ? 1 : 0));}

function sofGen_Gen(){
var fimg = xpath('//div[@id="menu"]/table[@width="110"]/tbody/tr/td/img[contains(@src,"gfx/info-help.jpg")]');
var simg = xpath('//div[@id="menu"]/table[@width="110"]/tbody/tr/td/img[contains(@src,"gfx/user-menu.jpg")]');
if (soSet['soGen_JumpGate']){
var telp = document.createElement('tr');
telp.innerHTML = '<td><div align="center"><a href="index.php?page=infos&session='+session+'&gid=43">'+i18n('Jump Gate',54)+'</a></div></td>';
fimg.parentNode.parentNode.parentNode.insertBefore(telp,fimg.parentNode.parentNode);}
if (soSet['soGen_MLst']){
var mlst = document.createElement('tr');
mlst.innerHTML = '<td><div align="center"><a style="color:lime" href="index.php?page=allianzen&session='+session+'&a=4&sort1='+soSet['soGen_MLstSort1']+'&sort2='+soSet['soGen_MLstSort2']+'">'+i18n('Member List',25)+'</a></div></td>';
fimg.parentNode.parentNode.parentNode.insertBefore(mlst,fimg.parentNode.parentNode.nextSibling);}
if (soSet['soGen_Banned']){
var bann = document.createElement('tr');
bann.innerHTML = '<td><div align="center"><a href="index.php?page=pranger&session='+session+'">'+i18n('Banned',33)+'</a></div></td>';
simg.parentNode.parentNode.parentNode.insertBefore(bann,simg.parentNode.parentNode);}
if(soSet['soGen_CircMes']){
var msgl = xpath('//div[@id="menu"]/table[@width="110"]/tbody/tr/td/div/font/a[@href="#"][contains(@onclick,"fenster")]');
var circ = document.createElement('tr');
circ.innerHTML = '<td><div align="center"><a style="color:lime" href="index.php?page=allianzen&session='+session+'&a=17">'+i18n('Circular Message',4)+'</a></div></td>';
msgl.parentNode.parentNode.parentNode.parentNode.parentNode.insertBefore(circ,msgl.parentNode.parentNode.parentNode.parentNode);}
if ((soSet['soGen_ChgButts']) && (Page != 'galaxy')){
var slct = xpath('//select[starts-with(@onchange,"haha(this)")]');
if(slct){
var slcti1 = (slct.selectedIndex-1 == -1 ? slct.selectedIndex-1+slct.length : slct.selectedIndex-1);
var slcti2 = (slct.selectedIndex+1 > slct.length-1 ? slct.selectedIndex+1-slct.length : slct.selectedIndex+1);
slct1 = slct.options[slcti1].value.match(/cp=(.*?)(?=&|$)/i) ? RegExp.$1 : '';
slct2 = slct.options[slcti2].value.match(/cp=(.*?)(?=&|$)/i) ? RegExp.$1 : '';
var butt = document.createElement('div');
butt.innerHTML = '<center><input type="button" style="cursor:pointer" value="<<<" onclick="document.location.href = \'/game/index.php?page=' + Page + '&session=' + session + '&cp=\' + slct1 + \'&mode='+Mode+'\';'+'" />&nbsp;&nbsp;<input type="button" style="cursor:pointer" value=">>>" onclick="document.location.href = \'/game/index.php?page=' + Page + '&session=' + session + '&cp=\' + slct2 + \'&mode='+Mode+'\';'+'" /></center>';
slct.parentNode.insertBefore(butt,slct.nextSibling);}}
if ((soSet['soGen_Moons']) && (Page != 'galaxy')){
var opts = xpaths('//select[starts-with(@onchange,"haha(this)")]/option');
for (var i = opts.snapshotLength - 1; i >= 0; i--){
var opt = opts.snapshotItem(i);
if (opt.innerHTML.match(/\(./)) opt.setAttribute('style','background-color:'+soSet['soGen_MoonsC']);}}
if (soGen_MenuL.length > 0){
var tbleg = xpath('//div[@id="menu"]/table[@width="110"]/tbody/tr[last()]');
mtrg = document.createElement('tr');
mtrg.id = 'soLnks';
mtrg.innerHTML = '<td align="center"><img src="data:image/gif;base64,R0lGODlhbgATAPYAAAIMDgQMFAYMGBEaIR0kLh8oLx8lMh8oMRwnOR8pOiApLiAnNCMqNSEmOSQsPCkvPioxPhkmQB4qQiEtRCkuQiYwQiozRCc1Tyw1Si45TDA7Ti86UDI9UzU/WDVBVjlCVjZCWjlFXSpOaTdGYTpGYTRKZTxKYzNOaj1NajVQbz9QbjZRcDlTcTlbekJOZkBOakJRbUVVckhXdUdYdkhZd0daektce09gflFifydggypihS5kijJkhzJnjT1miixslDZulzlulSdznStznzZznTx0nCl2oyt5pi18qjN2oT12oTt6pDF+q09fgktjgFJjhFVkilhnjlhojEZulkB7qTKAriyDtCqHuC6KvTODsyqOwiaRxySVzCSb1COe2SGh3SGj4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAABuABMAAAf+gCiCKCowKoQqh4OLjI2OgyaRkpOUJo+MkoKSI5ySJJwjISQkIaUgp6WpIB+sIasWA1Cys7S1UE+4ubq7vL26OMDBwDfENsbHyDY0NDIyMc8xMDAvL5qeo6anHNvbGxkZFhgXFQcBUlKy5+jq57a1vvDx8U30ycY00M/S+9OQJtiuQHjg5i0DBgzhEJaThWvWE3e35EmkR7GiRXq7mthTtswZtH3UqqGgRMqVBw8gOnTgoOEbuIMWFgSIAtEdFS9gcuakAlGirlpUuugE00VJPXsdm+WLQc3av3+kTp1cydIgwoQWCgSI6NNLlyxgwU7RVdGnL69hs3TpgpSZUn3+0kKKnARQ4Elu365iVQAA17GjNijmApNF2LAb9gwrNryL8BOKWcBQRLaMWT5+IkdGKhnw5MBtLa1CsGDhAYG+G1OjDbvEyQ3CxyLbKCI0Z5cis2sTVZL7SxXYscHYUKK7S5AYRIZ2AfJiaM4vV0qM2FF8h4fQBklrt1ChQN8a4GsYC08e/BKcQ7XYAG5D9tqwXbzYWK1WPtoi7NuDqUF/bQwfTATIxFoogLEFEluAccQVYPQQQhdcGCEhF11w0xJMpFEAgQPlPDFDeDaUJ2J5WHyxXhYh1hBZDYSFJxth8MkHHHsq7kfYDDPEEFkMMyTBBBI/glEgEiYgAQYJK4D+8UMICg4xoRegWaWXhhwG4CGOM9gwQ2VcdlnZi1l8CQYNhIlJZhbodUHEmcuUKeYMhEFjJAxa6PSFkSaAQaSRJKSgJJNGpKmDBhdimOEDDBBgZT45Yunoo1hGxiaOkcGZRaRjusmlm2ViGgMYVuxj5AvQacangiEcAUYIJygJAhhGWJjXQVdVUAEFDjiQaAA4SBPNr0tB40MVxBLrn1cCxvdpFkwY20UMXhVbhQ/LPrOWtMd2IeCoayHh7VokoKoqCK3+0AGERgihrghWkWbrAw/gqquivWIWDT/7JKfccUAUB8SnVaT5LxG6gUEEwM8QrBwQMPSbkxdGotBDcQ72KgiCqh6UoCQHOhScg17v5kpBAwzsigM1IOGr8sr4oqwnyzCv3BQjeG6WSkB2fYaXS4ZyV8EDueZKssko9zONXEgnrTQ1ei7tdNL+sOAtEmtBdfMpOXPTDc96uVtB0Aw4MLSiTzA1DQwovODC2my37fbbcMct99uTtKBTFzykwsrenoFGKHbtahdy0CQvsAABBAhgg2YkmDBC45VEvtkolI8ieeWVS27zzThjLZDWO8+KkK2kkx706Q4YQMACBhggwAURRCDB7BJUQPvtuN8+we689+7778AHr7vvs/fuQALIB408Aswj77zzDTTQ+vStr966AIEAADs%3D" alt="sog" /></td>';
tbleg.parentNode.insertBefore(mtrg,tbleg.nextSibling);
var n = soGen_MenuL.length;
for (var i = n - 1; i >= 1 ; i--){
sofSys_AMI(soGen_MenuL[i][0],soGen_MenuL[i][1],soGen_MenuL[i][2],soGen_MenuL[i][3]);}}}

//### OVERVIEW ###

function sofMen_Clock(){
var th = xpath('//body/div[starts-with(@id,"content")]/center/table[@width="519"]/tbody/tr/th[@colspan="3"][1]');
th.previousSibling.innerHTML = (soSet['soGen_ClockI'] ? i18n('Server Time',40) : i18n('Local Time',18));
th.innerHTML = '<span id="OverviewClock" style="color:'+(soSet['soGen_ClockI'] ? soSet['soGen_ClockC'] : soSet['soMen_ClockC'])+';font-weight:bold" title="'+(soSet['soGen_ClockI'] ? sofSys_ServSecs()/1000+' [s]' : '')+'"></span>';
var tr = th.parentNode;
sofGen_AddRefr('sofUpd_MenuClock',500);}

function sofUpd_MenuClock(){
var ovrvmTime = (soSet['soGen_ClockI'] ? new Date(new Date().getTime() + sofSys_ServSecs()) : new Date(new Date().getTime()));
if (ovrvmT = document.getElementById('OverviewClock'))
ovrvmT.innerHTML = parseDate(ovrvmTime, soSet['soGen_ClockF'], (soSet['soGen_ClockI'] ? 0 : 1));}

function sofMen_Fields(){
var astat = xpath('//body/div[starts-with(@id,"content")]/center/table/tbody/tr/th[@colspan="3"]/a[contains(@href,"index.php?page=statistics")]');
var th = astat.parentNode.parentNode.previousSibling.previousSibling.previousSibling.childNodes[1];
var fields = th.innerHTML.split('(');
var size = parseInt(fields[0].match(/[0-9]+/g).join(''));
var fieldsize = Math.ceil(size*size/1000000-1);
th.innerHTML += ' ['+fieldsize+']';}

function sofMen_ResOver(){
var as = xpaths('//table[@width="519"]/tbody/tr/th/span/a[contains(@onmouseover,"return overlib")][2]');
if (as.snapshotLength == 0) return;
var metal1 = crystal1 = deuter1 = metal2 = crystal2 = deuter2 = metal3 = crystal3 = deuter3 = metal4 = crystal4 = deuter4 = 0;
for (var i = as.snapshotLength - 1; i >= 0; i--){
var a = as.snapshotItem(i);
tmpa = a.getAttribute('onmouseover').replace(/[.]/g, '').match(/\d+/g);
var acl = a.getAttribute('class');
var metal = parseInt(tmpa[0]);
var crystal = parseInt(tmpa[1]);
var deuter = parseInt(tmpa[2]);
switch (acl){
case 'ownattack':
metal1 += metal; crystal1 += crystal; deuter1 += deuter; break;
case 'ownfederation':
metal1 += metal; crystal1 += crystal; deuter1 += deuter; break;
case 'owntransport':
metal2 += metal; crystal2 += crystal; deuter2 += deuter; break;
case 'owndeploy':
metal3 += metal; crystal3 += crystal; deuter3 += deuter; break;
case 'ownharvest':
metal4 += metal; crystal4 += crystal; deuter4 += deuter;}}
var totmet = metal1+metal2+metal3+metal4;
var totcrys = crystal1+crystal2+crystal3+crystal4;
var totdeut = deuter1+deuter2+deuter3+deuter4;
var newt = xpath('//table[@width="519"]');
var newtb = document.createElement('table');
newtb.setAttribute('width','519');
newtb.setAttribute('id','resOverview');
newtb.setAttribute('style','text-align:center;'+((totmet+totcrys+totdeut) == 0 ? 'display:none' : ''));
newtb.innerHTML = '<tr><th colspan="4" style="color:lime;text-align:left">'+i18n('Resources',39)+'</th></tr><tr><td class="c">'+i18n('Missions',27)+'</td><td class="c">'+i18n('Metal',26)+'</td><td class="c">'+i18n('Crystal',6)+'</td><td class="c">'+i18n('Deuterium',9)+'</td></tr>'+((metal1+crystal1+deuter1) != 0 ? '<tr><th>'+i18n('Attack',19)+'</th><th>' + AddCommas(metal1) + '</th><th>' + AddCommas(crystal1) + '</th><th>' + AddCommas(deuter1) + '</th></tr>' : '')+((metal2+crystal2+deuter2) != 0 ? '<tr><th>'+i18n('Transport',23)+'</th><th>' + AddCommas(metal2) + '</th><th>' + AddCommas(crystal2) + '</th><th>' + AddCommas(deuter2) + '</th></tr>' : '')+((metal3+crystal3+deuter3) != 0 ? '<tr><th>'+i18n('Deploy',20)+'</th><th>' + AddCommas(metal3) + '</th><th>' + AddCommas(crystal3) + '</th><th>' + AddCommas(deuter3) + '</th></tr>' : '')+((metal4+crystal4+deuter4) != 0 ? '<tr><th>'+i18n('Harvest',22)+'</th><th>' + AddCommas(metal4) + '</th><th>' + AddCommas(crystal4) + '</th><th>' + AddCommas(deuter4) + '</th></tr>' : '')+'<tr><th style="color:lime">'+i18n('Total',55)+'</th><th style="color:lime">' + AddCommas(totmet) + '</th><th style="color:lime">' + AddCommas(totcrys) + '</th><th style="color:lime">' + AddCommas(totdeut) + '</th></tr></table>';
newt.parentNode.insertBefore(newtb, newt.nextSibling);}

function sofMen_Enh(){
var img = xpath('//div[@id="content"]/center/table[@width="519"]/tbody/tr/th/img[@width="200"][@height="200"]');
img.setAttribute('width','150');
img.setAttribute('height','150');
var as = xpaths('//th[@class="s"]/table[@class="s"]/tbody/tr/th/a[@title]');
var coords = new Array();
var works = new Array();
var lnks = new Array();
var imgs = new Array();
var nmes = new Array();
for (var i = as.snapshotLength - 1; i >= 0; i--){
var a = as.snapshotItem(i);
var titl = a.getAttribute('title').match(/\[(\d*):(\d*):(\d*)\]/);
coords.push(titl);
var work = a.parentNode.getElementsByTagName('center')[0].innerHTML.replace(/<.*?>/g, '');
works.push(work);
var nme = a.parentNode.text.replace(work,'');
nmes.push(nme);
var lnk = a.href.match(/cp=(.*?)(?=&|$)/i)[1];
lnks.push(lnk);
var img = a.firstChild.src;
imgs.push(img);}
var ntt = xpath('//th[@class="s"]/table[@class="s"]');
var nt = ntt.parentNode;
ntt.style.display = 'none';
var newo = '';
for (k = lnks.length-1; k >= 0; k--){
newo += '<tr><th><a href="index.php?page=overview&session='+session+'&cp='+lnks[k]+'" title="'+nmes[k]+'"><img src="'+imgs[k]+'" style="width:30px;height:30px" /></a></th><th style="text-align:left"><a href="/game/index.php?page=galaxy&session='+session+'&galaxy='+coords[k][1]+'&system='+coords[k][2]+'" title="'+coords[k][0]+'">'+nmes[k]+'</a><br /><a href="/game/index.php?page=b_building&session='+session+'&cp='+lnks[k]+'">'+ works[k]+'</a></th></tr>';}
nt.innerHTML = '<table>'+newo+'</table>';}

//### RESOURCES ###

function calcProd_plus(id){
document.getElementById(id).value ++;
calcProd();}

function calcProd(){
var p_th = xpath('//table[@width="550"]/tbody/tr/th[@colspan=6]');
var p_tr = p_th.parentNode.nextSibling.childNodes;
var pMetal = DelCommas(p_tr[1].lastChild.innerHTML);
var pKristal = DelCommas(p_tr[2].lastChild.innerHTML);
var pDeut = DelCommas(p_tr[3].lastChild.innerHTML);
var days = document.getElementById('pDays').value;
var hours = document.getElementById('pHours').value;
var toth = parseInt(days)*24+parseInt(hours);
document.getElementById('pMetl').innerHTML = AddCommas(toth*pMetal);
document.getElementById('pKrist').innerHTML = AddCommas(toth*pKristal);
document.getElementById('pDeut').innerHTML = AddCommas(toth*pDeut);}

function sofRes_Gen(){
if (soSet['soRes_ProdCalc']){
var p_tb = xpath('//table[@width="550"]');
var op = xpath('//table[@width="550"]/tbody/tr[3]/td[@class="k"][1]');
if (op.innerHTML != 0){
var p_ntb = document.createElement('table');
p_ntb.setAttribute('width','550');
p_ntb.innerHTML = '<tr><td class="c" colspan="5">'+i18n('Resources Production Calculator',36)+'</td></tr><tr><th width="38%">'+i18n('Calculate production per',2)+':</th><th width="16%">'+i18n('Metal',26)+'</th><th width="16%">'+i18n('Crystal',6)+'</th><th width="16%">'+i18n('Deuterium',9)+'</th></tr><tr><th><input size="3" id="pDays" value="0" onchange="calcProd()" onKeyUp="calcProd()" />  <a title="+1" href="javascript:calcProd_plus(\'pDays\')">'+ i18n('day(s)',7)+'</a> : <input size="3" id="pHours" value="0" onchange="calcProd()" onKeyUp="calcProd()" /> <a title="+1" href="javascript:calcProd_plus(\'pHours\')">'+ i18n('hour(s)',14)+'</a></th><td class="k" style="color:#00ff00" id="pMetl">0</td><td class="k" style="color:#00ff00" id="pKrist">0</td><td class="k" style="color:#00ff00" id="pDeut">0</td><td class="k"><input type="button" value="'+i18n('Reset',61)+'" onclick="document.getElementById(\'pDays\').value = \'0\';document.getElementById(\'pHours\').value = \'0\';calcProd()"></td></td></tr>'
p_tb.parentNode.insertBefore(p_ntb, p_tb.nextSibling);}}
if (soSet['soRes_StStatus']){
var st_th = xpath('//table[@width="550"]/tbody/tr/th[@colspan=6]');
var st_tr = st_th.parentNode.previousSibling;
var stMetal = DelCommas(st_tr.childNodes[1].lastChild.innerHTML);
var stKristal = DelCommas(st_tr.childNodes[2].lastChild.innerHTML);
var stDeut = DelCommas(st_tr.childNodes[3].lastChild.innerHTML);
var Resources = sofSys_GetRes();
var strMetal = Math.round((parseInt(Resources[0]))/(stMetal*10));
var strKristal = Math.round((parseInt(Resources[1]))/(stKristal*10));
var strDeut = Math.round((parseInt(Resources[2]))/(stDeut*10));
stMColr = stKColr = stDColr = 'lime';
if (strMetal > 90 && strMetal < 100){stMColr = 'orange';}
else if (strMetal >= 100){stMColr = 'red';}
if (strKristal > 90 && strKristal < 100){stKColr = 'orange';}
else if (strKristal >= 100){stKColr = 'red';}
if (strDeut > 90 && strDeut < 100){stDColr = 'orange';}
else if (strDeut >= 100){stDColr = 'red';}
var st_ntr = document.createElement('tr');
st_ntr.innerHTML = '<th colspan="2">'+i18n('Storage Status',52)+'</th><td class="k"><font color="'+stMColr+'">'+strMetal+'%</font></td><td class="k"><font color="'+stKColr+'">'+strKristal+'%</font></td><td class="k"><font color="'+stDColr+'">'+strDeut+'%</font></td><td class="k"><font color="#00ff00">-</font></td>'
st_tr.parentNode.insertBefore(st_ntr, st_tr.nextSibling);}
if (soSet['soRes_ProdFact']){
var faktp = xpath('//div[@id="content"]/center/center/br[2]');
var faktt = faktp.nextSibling.nodeValue;
faktor = faktt.split(':');
faktor = parseFloat(faktor[1])*100;
var graf = '<table width="550"><tr><th width="200" align="center">'+faktt+'</th><th align="center"><div style="text-align:left;border:1px solid white;width:350px;"><div id="faktr" style="background-color:'+(faktor < 100 ? '#C00000' : '#00C000' )+';text-align:center;color:white">'+faktor+'%</div></div></th></tr></table><br />'
var content = xpath('//div[@id="content"]');
content.innerHTML = content.innerHTML.replace(faktt,graf);
for (var i = 0; i <= faktor; i++){setTimeout('document.getElementById("faktr").style.width="'+i+'%"', 16*i);}}
if (soSet['soRes_SatEnerg']){
var selc = xpath('//table[@width="550"]/tbody/tr/th/select[@name="last212"]');
if (selc){
var totenrg = DelCommas(selc.parentNode.previousSibling.childNodes[1].childNodes[1].innerHTML);
var satt = selc.parentNode.parentNode.childNodes[0];
var sat = satt.innerHTML.match(/\d+/);
satt.innerHTML += '<br /> <font size="smaller" color="lime">'+i18n('Energy',11)+': '+Math.round(totenrg/sat)+'</font>';}}}

//### GALAXY ###

function sofGal_PlntLst() {
if (document.getElementById('PlanetsList') || (typeof(soUpd_PlntCrds) != 'undefined')) return;
var table = document.getElementById('t1');
if (! table) return;
var Planets = soGetCookie('soSet_Planets');
if (Planets != '') {
var tr = document.createElement('tr');
tr.setAttribute('class', 'header');
tr.innerHTML = '<td class="header" colSpan="2" align="center" style="background-color: transparent; border: 0px;"></td>'
var select = tr.childNodes[0].appendChild(document.createElement('select'));
select.id  = 'PlanetsList';
select.setAttribute('onchange', 'sofUpd_PlntCrds(this.options[this.selectedIndex].value);document.location.href = \'/game/index.php?page=' + Page + '&session=' + session + '&cp=\' + this.options[this.selectedIndex].value; + \'&mode=&gid=&messageziel=&re=0\';');
var PlanetsList = Planets.split('||');
for (var i = 0, Planet = ''; Planet = PlanetsList[i]; i++) {
var option  = select.appendChild(document.createElement('option'));
Planet = Planet.split('==');
option.value = Planet[0];
option.text  = Planet[1];
if (soSet['soGen_Moons']){if (option.text.match(/\(./)) option.setAttribute('style','background-color:'+soSet['soGen_MoonsC']);}
if (Planet[2] == 1)
option.selected = 'selected';}
table.parentNode.parentNode.insertBefore(tr, table.parentNode);}}

function sofGal_Hl(){
if (soSet['soGal_HlDebrS'] > 0){
var as = xpaths('//a[contains(@onmouseover,"debris.jpg")]');
for (var i = as.snapshotLength - 1; i >= 0; i--){
var a = as.snapshotItem(i);
var ress = a.getAttribute('onmouseover').replace(/[\s.]/g, '').match(/<th>(\d*)<\/th>.*<th>(\d*)<\/th>/i);
var metal = parseInt(ress[1]);
var krist = parseInt(ress[2]);
var dbrsz = metal+krist;
if (soSet['soGal_DebrRemI'])
a.innerHTML = '<span style="font-size:3">'+metal+'<br />'+krist+'</span>';
a.parentNode.setAttribute('style', (((soSet['soGal_HlDebrS'] > 0) && (dbrsz >= soSet['soGal_HlDebrS'])) ? 'background-color:' + soSet['soGal_HlDebrC'] : ''));}}
if (soSet['soGal_HlMoonsS'] > 0){
var imgs = xpaths('//img[contains(@src,"small/s_mond.jpg")]');
for (var i = imgs.snapshotLength - 1; i >= 0; i--){
var img = imgs.snapshotItem(i);
var moon = img.getAttribute('alt').split(':');
var moonsize = parseInt(moon[1]);
if (moonsize >= soSet['soGal_HlMoonsS'])
img.parentNode.parentNode.setAttribute('style', 'background-color:' + soSet['soGal_HlMoonsC']);}}}

function sofGal_AllC(){
var content = document.getElementById('content');
if (! content) return;
var as = content.getElementsByTagName ('a');
for (var i = as.length - 1; i >= 0; i--){
alianza = as[i].innerHTML;
alianzac = alianza + '#';
var n1 = soGal_AllC.length;
for (var k = n1 - 1; k >= 1; k--){
var n2 = soGal_AllC[k].length;
for (var j = n2 - 1; j > 1; j--){
if(alianzac.search(soGal_AllC[k][j]+' #') != -1 ){
if (soGal_AllC[k][0]!=''){
as[i].innerHTML = alianza+'('+soGal_AllC[k][0]+')';}
as[i].style.color = soGal_AllC[k][1];}}}}}

function sofGal_Ranks(){
var aps = xpaths('//th[@width="150"]/a[@onmouseover]');
for (var i = aps.snapshotLength - 1; i >= 0; i--){
var ap = aps.snapshotItem(i);
var rank = ap.getAttribute('onmouseover').match(/[^\d](\d*)[^\d]*<\/td>/i)[1];
ap.parentNode.innerHTML+='<span style="color:orange;font-size:smaller">#'+parseInt(rank)+'</span>';}
var aas = xpaths('//th[@width="80"]/a[@onmouseover]');
for (var i = aas.snapshotLength - 1; i >= 0; i--){
var aa = aas.snapshotItem(i);
var onmsovr = aa.getAttribute('onmouseover')
var ranka = onmsovr.match(/[^\d](\d*)[^\d]*\d*[^\d]*<\/td>/i)[1];
var nmbmb = onmsovr.match(/[^\d](\d*)[^\d]*[^\d]*<\/td>/i)[1];
aa.parentNode.innerHTML+='<span style="color:orange;font-size:smaller;white-space:nowrap">#'+ranka+'/'+nmbmb+'</span>';}}

function sofGal_PhalStat(){
var td = xpath('//tr[@id="fleetstatusrow"]').previousSibling.childNodes[0];
var phalanx = xpath('//table[@width="569"]/descendant::tr/th[3]/a[starts-with(@onclick,"fenster(")]');
if ((td.getAttribute('colspan') != 8) || (! phalanx)) return;
var deut = parseInt(td.text.replace(/[.]/g, '').match(/\d+/));
var img = '<img title="'+i18n('Phalanx Range',31)+'" src="' + (((deut > 5000) && (phalanx))? 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIBAMAAAA2IaO4AAAAAXNSR0IArs4c6QAAACpQTFRF1NDIDngAEZQAEpoAFKwAGM4AGuAAHPAAKP8LVv8/gICAgv9x0v/L////LLCNPgAAAAF0Uk5TAEDm2GYAAAABYktHRACIBR1IAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH2AgJDhEJX1qGFwAAAC9JREFUCNdjYFgoxcDAeHqqAsOaO9u8GKRPT3NkkNzZ5siwvLzUioExLUSAAaQEAPTTC25bZYTUAAAAAElFTkSuQmCC" alt="on" />' : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIBAMAAAA2IaO4AAAAAXNSR0IArs4c6QAAAC1QTFRF1NDIeAAJgICAkwAKmgALqwAMzgAP3wAQ8AAR8Rgi9ElK9aOI93x4+IZ3////uQ7F8QAAAAF0Uk5TAEDm2GYAAAABYktHRACIBR1IAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH2AgJDhAbtfjGHgAAAC9JREFUCNdjYFAUYmBg3LvMgEH79fEgBtk9ywMZpE5ND2TQ6GhzYmAsTxVgACkBANgQCizwvXt6AAAAAElFTkSuQmCC" alt="off" />');
td.innerHTML = img + '&nbsp;' + td.innerHTML;}

function sofGal_galaxyFix(){
var skripta = document.getElementById('content').getElementsByTagName('script')[2];
skripta.text = skripta.text.replace(/test/g, '0');}

//### BUILDINGS ###

function sofBld_EndTime(){
var bx = document.getElementById('bx');
var atr= document.getElementsByName('Atr');
var bxx= document.getElementById('bxx');
var bxy= document.getElementById('bxy');
var bxxend = document.getElementById('bxxend');
var bxyend = document.getElementById('bxyend');
if ((bxx) && (!bxxend)){
var buildingTd = bxx.parentNode;
var scripts = buildingTd.getElementsByTagName('script');
if (scripts.length > 0){
if ((scripts[0].text.search(/ss=(\d*?);/i) != -1) || (scripts[0].text.search(/pp=(?:"|')(\d*?)(?:"|');/i) != -1)) {
var endTime = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(RegExp.$1) * 1000);
var newDiv = buildingTd.appendChild(document.createElement('div'));
newDiv.innerHTML = parseDate(endTime, soSet['soBld_EndTimeF']);
newDiv.id= 'bxxend';
newDiv.setAttribute('class', 'z');
newDiv.setAttribute('style', 'text-align:center;white-space:nowrap;color:'+soSet['soBld_EndTimeC']+';');}}}
if ((bxy) && (!bxyend)){
if (bxy.getAttribute('title')){
var endTime = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(bxy.getAttribute('title')) * 1000);
var newDiv   = bxy.parentNode.appendChild(document.createElement('div'));
newDiv.innerHTML = parseDate(endTime, soSet['soBld_EndTimeF']);
newDiv.id= 'bxyend';
newDiv.setAttribute('style','text-align:center;whity-space:nowrap;color:'+soSet['soBld_EndTimeC']+';');}}
if ((bx) && (atr.length > 0) && (! bxxend)){
var seconds = 0;
var timeList = bx.parentNode.innerHTML.substr(-100).match(/\D\d+\D/g);
for (var i = 0, time = ''; time = parseInt(timeList[i]); i++) {
var j = i + 4 - timeList.length;
if (j == 0) seconds += time * 86400;
if (j == 1) seconds += time * 3600;
if (j == 2) seconds += time * 60;
if (j == 3) seconds += time;}
if (seconds > 0){
var endTime = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(seconds) * 1000);
var newDiv = bx.parentNode.insertBefore(document.createElement('div'), bx.parentNode.childNodes[bx.parentNode.childNodes.length - 4]);
newDiv.innerHTML = i18n('End time', 10) + ': ' + parseDate(endTime, soSet['soBld_EndTimeF']);
newDiv.id= 'bxxend';
newDiv.setAttribute('style', 'text-align:center;white-space:nowrap;color:'+soSet['soBld_EndTimeC']+';');}}}

function sofBld_InfDiff(){
var table = xpath('//div[@id="content"]/center/table[@width="519"]/tbody/tr/th/center/table[@border="1"]');
var fonts = table.getElementsByTagName('font');
for (var i = 0, font = ''; font = fonts[i]; i++){
if (font.color.toLowerCase() != 'ff0000') continue;
var current = font.parentNode.parentNode.childNodes; break;}
var reach = DelCommas(current[1].innerHTML);
var rows = table.firstChild.childNodes;
for (var i = 1, row = ''; row = rows[i].childNodes; i++){
if (document.getElementById('InfoDiff' + i)) continue;
var reachDiff = DelCommas(row[1].innerHTML) - reach;
if (reachDiff != 0) {
var newSpan = row[1].appendChild(document.createElement('span'));
newSpan.innerHTML = ' (' + AddCommas(reachDiff) + ')';
newSpan.id= 'InfoDiff' + i;
newSpan.setAttribute('style', 'text-align: center; color: #' + (reachDiff > 0 ? '00FF00' : 'FF0000') + ';');}}}

function sofBld_Bld(){
var Resources = sofSys_GetRes();
if (Resources == -1) return;
var ResNames = sofSys_GetResName();
var Bimgs = xpaths('//td[@class="l"]/a[contains(@href,"gid")]/img[contains(@src,"gebaeude")]');
if (Bimgs.snapshotLength == 0) return;
for (var i = Bimgs.snapshotLength - 1; i >= 0; i--){
var Bimg = Bimgs.snapshotItem(i);
var Building = Bimg.parentNode.parentNode.nextSibling;
if ((soSet['soBld_ResRem']) && (Building.innerHTML.search(/<b>/i))){
var j = 0;
var ResourcesRemained = 0;
var bResources = Building.getElementsByTagName('b');
if (Building.innerHTML.search(new RegExp(ResNames[0] + '[^(<br>)]*<b>', 'i')) != -1){
var Metal = parseInt(bResources[j].innerHTML.replace(/\./g, ''));
if (Metal > Resources[0]){
bResources[j].innerHTML += ' <span style="color: ' + soSet['soBld_ResRemC'] + ';">(-' + AddCommas(Metal - Resources[0]) + ')</span>';
ResourcesRemained   += parseInt(Metal - Resources[0]);}
j++;}
if (Building.innerHTML.search(new RegExp(ResNames[1] + '[^(<br>)]*<b>', 'i')) != -1){
var Crystal   = parseInt(bResources[j].innerHTML.replace(/\./g, ''));
if (Crystal > Resources[1]){
bResources[j].innerHTML += ' <span style="color: ' + soSet['soBld_ResRemC'] + ';">(-' + AddCommas(Crystal - Resources[1]) + ')</span>';
ResourcesRemained   += parseInt(Crystal - Resources[1]);}
j++;}
if (Building.innerHTML.search(new RegExp(ResNames[2] + '[^(<br>)]*<b>', 'i')) != -1){
var Deuterium = parseInt(bResources[j].innerHTML.replace(/\./g, ''));
if (Deuterium > Resources[2]){
bResources[j].innerHTML += ' <span style="color: ' + soSet['soBld_ResRemC'] + ';">(-' + AddCommas(Deuterium - Resources[2]) + ')</span>';
ResourcesRemained   += parseInt(Deuterium - Resources[2]);}
j++;}
if (Building.innerHTML.search(new RegExp(ResNames[3] + '[^(<br>)]*<b>', 'i')) != -1) {
var Energy = parseInt(bResources[j].innerHTML.replace(/\./g, ''));
if (Energy > Resources[3]){
bResources[j].innerHTML += ' <span style="color: ' + soSet['soBld_ResRemC'] + ';">(-' + AddCommas(Energy - Resources[3]) + ')</span>';}
j++;}
if ((soSet['soBld_CargRem']) && (ResourcesRemained > 0)){
Building.innerHTML  += i18n('Cargos',3) + ': <span style="color: ' + soSet['soBld_CargRemC'] + ';">' + Math.ceil(ResourcesRemained / 5000) + ' ' + i18n('SC',41) + '</span> ' + i18n('or',29);
Building.innerHTML  += ' <span style="color: ' + soSet['soBld_CargRemC'] + ';">' + Math.ceil(ResourcesRemained / 25000) + ' ' + i18n('LC',17) + '</span><br>';}}
if ((soSet['soBld_RemDesc']) || (soSet['soBld_ResImg'] >= 0)){
Building.previousSibling.style.display = (soSet['soBld_ResImg'] == 0 ? 'none' : '');
Bimg.width = ((soSet['soBld_ResImg'] <= 150) && (soSet['soBld_ResImg'] > 0) ? soSet['soBld_ResImg'] : 120);
Bimg.height = ((soSet['soBld_ResImg'] <= 150) && (soSet['soBld_ResImg'] > 0) ? soSet['soBld_ResImg'] : 120);
Building.innerHTML = (soSet['soBld_RemDesc'] ? Building.innerHTML.replace(/^(.*?<br>)(.*<br>)(.*?<b>)/i, '$1$3') : Building.innerHTML);
if((soSet['soBld_ImpMsg']) && (Mode != 'Flotte') && (Building.nextSibling.childNodes.length == 1) && (Building.nextSibling.innerHTML != ' - ') && (Building.nextSibling.childNodes[0].tagName.toLowerCase() == 'font')) Building.nextSibling.firstChild.innerHTML = i18n('Impossible',15);}
if (soSet['soBld_Range']){
var option = xpath('//select[starts-with(@onchange,"haha(this)")]');
var coord = option.options[option.selectedIndex].text.match(/\[(\d*):(\d*):(\d*)\]/);
var coordG = parseInt(coord[1]);
var coordS = parseInt(coord[2]);
if (((Page == 'buildings') && (Mode == 'Forschung') && (Bimg.src.match('gebaeude/117.gif'))) || ((Page == 'b_building') && (Bimg.src.match('gebaeude/42.gif')))){
var level = (isNaN(parseInt(Building.innerHTML.match(/<\/a>[^\d]*(\d*)[^\d]*<br/i)[1])) ? 0 : parseInt(Building.innerHTML.match(/<\/a>[^\d]*(\d*)[^\d]*<br/i)[1]));
if (level == 0) return;
var range = (Bimg.src.match('gebaeude/117.gif') ? (level*5 - 1) : (level*level - 1));
var range1 = (coordS-range < 1 ? 1 : coordS-range);
var range2 = (coordS+range > 499 ? 499 : coordS+range);
range1 = coordG+':'+range1;
range2 = coordG+':'+range2;
Building.innerHTML += '<br /><span style="color: orange;">'+ (Bimg.src.match('gebaeude/117.gif') ? i18n('IPM Range',16) : i18n('Phalanx Range',31)) +': <b>'+range+'</b> '+i18n('systems',53)+' ('+range1+' - '+range2+')</span>';}}
if ((Page == 'b_building') && (soSet['soBld_Energ'])){
var level = (isNaN(parseInt(Building.innerHTML.match(/<\/a>[^\d]*(\d*)[^\d]*<br/i)[1])) ? 0 : parseInt(Building.innerHTML.match(/<\/a>[^\d]*(\d*)[^\d]*<br/i)[1]));
for (var z = 1; z < 5; z++){
if (Bimg.src.match('gebaeude/'+[z]+'.gif')){
var factor = ((z == 3) || (z == 4) ? 20 : 10);
var ener1 = Math.ceil(factor*level*Math.pow(1.1,level));
var ener2 = Math.ceil(factor*(level+1)*Math.pow(1.1,(level+1)));
var energy = (z == 4 ? -(-(ener2-ener1) - Resources[4]) : (Resources[4] - (ener2-ener1)));
Building.innerHTML += i18n('Energy',11)+': <span style="color:'+(energy<0 ? 'red' : 'lime')+'">'+energy+'</span>';}}}}}

//### FLEET ###

function sofFlt_ArrTime(){
var fleetDivs = xpaths('//tr/th/div[starts-with(@id,"bxx")]');
if (fleetDivs.snapshotLength == 0) return;
for (var i = fleetDivs.snapshotLength - 1; i >= 0; i--){
var fleetDiv = fleetDivs.snapshotItem(i);
if (fleetDiv.getAttribute('title'))
var arrivalTime = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(fleetDiv.getAttribute('title')) * 1000);
else continue;
var newDiv = fleetDiv.parentNode.appendChild(document.createElement('div'));
newDiv.innerHTML = parseDate(arrivalTime, soSet['soFlt_ArrTimeF']);
newDiv.id = fleetDiv.id + 'end';
newDiv.setAttribute('style', 'text-align: center; white-space: nowrap; color: ' + soSet['soFlt_ArrTimeC'] + ';');}}

function sofFlt_CmBckTime(){
var returnFleets = xpaths('//input[@name="order_return"]');
if (returnFleets.snapshotLength == 0) return;
for (var i = returnFleets.snapshotLength - 1; i >= 0; i--){
var returnFleet = returnFleets.snapshotItem(i);
var newDiv= returnFleet.parentNode.getElementsByTagName('div');
if (newDiv.length < 1) {
var newInput   = returnFleet.parentNode.appendChild(document.createElement('input'));
newInput.setAttribute('name', 'SendTime');
newInput.setAttribute('type', 'hidden');
newInput.value = new Date(returnFleet.parentNode.parentNode.parentNode.childNodes[4].innerHTML).getTime();
var newDiv = returnFleet.parentNode.appendChild(document.createElement('div'));
newDiv.setAttribute('style', 'text-align: center; white-space: nowrap; color: ' + soSet['soFlt_CmBckTimeC'] + ';');}}
sofGen_AddRefr('sofUpd_CmBckTime',500);}

function sofUpd_CmBckTime(){
var returnFleets = document.getElementsByName('SendTime');
if (returnFleets.length < 1) return;
for (var i = 0, returnFleet = ''; returnFleet = returnFleets[i]; i++) {
var comeBackTime = new Date(2 * (new Date().getTime() + sofSys_ServSecs()) - parseInt(returnFleet.value));
returnFleet.parentNode.getElementsByTagName('div')[0].innerHTML = parseDate(comeBackTime, soSet['soFlt_CmBckTimeF']);}}

function sofFlt_Cap(){
var content = document.getElementById('content');
if (! content) return;
var divCapacity = document.getElementById('FleetsCapacity');
var capacity = 0;
var inputs  = content.getElementsByTagName('input');
for (var i = 0, input = ''; input = inputs[i]; i++) {
if ((input.getAttribute('name')) && (input.getAttribute('name').substr(0,4) == 'ship') && (input.getAttribute('name').substr(4) != '210') && (! isNaN(parseInt(input.value)))) {
capacity += parseInt(document.getElementsByName('capacity' + input.getAttribute('name').substr(4))[0].value) * parseInt(input.value);
if ((! divCapacity) && (! thCapacity)){
var thCapacity = input.parentNode.parentNode.parentNode;
thCapacity = (thCapacity.childNodes[0].lastChild.tagName.toLowerCase() != 'th' ? thCapacity.childNodes[1].lastChild : thCapacity.childNodes[2].lastChild);}}}
if (thCapacity){
thCapacity.innerHTML = '<div id="FleetsCapacity" style="text-align: center; color: ' + soSet['soFlt_CapC'] + ';"></div>';
var divCapacity  = thCapacity.firstChild;
sofGen_AddRefr('sofFlt_Cap',250);}
if (divCapacity)
divCapacity.innerHTML = AddCommas(capacity);}

function sofFlt_SndTime(){
var consumption = document.getElementById('consumption');
var resources = document.getElementById('remainingresources');
var arrivalTime = document.getElementById('ArrivalTime');
var comeBackTime = document.getElementById('ComeBackTime');
if (consumption){
if (! arrivalTime){
var newTr = consumption.parentNode.parentNode.parentNode.insertBefore(document.createElement('tr'), consumption.parentNode.parentNode);
newTr.setAttribute('height', '20');
newTr.innerHTML  = '<th>' + i18n('Arrival time',1) + ':</th><th><div id="ArrivalTime" style="text-align: center; white-space: nowrap; color: ' + soSet['soFlt_SndTimeC'] + ';">-</div></th>';
var arrivalTime = newTr.lastChild.lastChild;}
if (! comeBackTime){
var newTr= consumption.parentNode.parentNode.parentNode.insertBefore(document.createElement('tr'), consumption.parentNode.parentNode);
newTr.setAttribute('height', '20');
newTr.innerHTML  = '<th>' + i18n('Comeback time',5) + ':</th><th><div id="ComeBackTime" style="text-align: center; white-space: nowrap; color: ' + soSet['soFlt_SndTimeC'] + ';">-</div></th>';
var comeBackTime = newTr.lastChild.lastChild;}}
else if (resources){
var td = resources.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.getElementsByTagName('tr')[0].firstChild;
if (! arrivalTime)
td.innerHTML += ' - <span id="ArrivalTime" style="color: '+soSet['soFlt_SndTimeC']+';">-</span> /';
if (! comeBackTime)
td.innerHTML += ' <span id="ComeBackTime" style="color: '+soSet['soFlt_SndTimeC']+';">-</span>';}
sofGen_AddRefr('sofUpd_SndTime',250);}

function sofUpd_SndTime(){
var divArrivalTime  = document.getElementById('ArrivalTime');
var divComeBackTime = document.getElementById('ComeBackTime');
if ((! divArrivalTime) || (! divComeBackTime)) return;
var expeditionTime = document.getElementsByName('expeditiontime');
var parkingTime= (expeditionTime.length > 0 ? expeditionTime[0].value * 3600000 : 0);
var arrivalTime  = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(duration()) * 1000);
var comeBackTime = new Date(new Date().getTime() + sofSys_ServSecs() + parseInt(duration()) * 2000 + parkingTime);
divArrivalTime.innerHTML  = parseDate(arrivalTime, soSet['soFlt_SndTimeF']);
divComeBackTime.innerHTML = parseDate(comeBackTime, soSet['soFlt_SndTimeF']);}

function sofFlt_TransCalc(){
var Resources = sofSys_GetRes();
var ctMet = parseInt(Resources[0]);
var ctCry = parseInt(Resources[1]);
var ctDeut = parseInt(Resources[2]);
var TotRess = ctMet+ctCry+ctDeut;
var tc = xpath('//form[contains(@action,"page=flotten2")]/table[@width="519"]');
tc_ntb = document.createElement('table');
tc_ntb.setAttribute('width','519');
tc_ntb.innerHTML = '<tr><td class="c" colspan="3">'+i18n('Transport Calculator',56)+'</td></tr><tr><td class="k" width="25%">'+i18n('Metal',26)+':</td><td width="35%" class="k"><input size="12" id="tcMetal" value="'+AddCommas(ctMet)+'" onchange="javascript:CalcRes()" onkeyup="javascript:CalcRes()" /></td><td class="k" rowspan="3" style="line-height:175%;"><a style="cursor:pointer;color: '+soSet['soFlt_ResC']+';" onclick="javascript:Reset_CalcRes('+ctMet+','+ctCry+','+ctDeut+');">'+i18n('Resources',39)+': '+AddCommas(TotRess)+'</a><br /><input type="text" size="12" id="resTotl" value="'+AddCommas(TotRess)+'" /><div style="text-align: center;" id="CargosNeeded"></div></td></tr><tr><td class="k">'+i18n('Crystal',6)+':</td><td class="k"><input size="12" id="tcCrystal" value="'+AddCommas(ctCry)+'" onchange="javascript:CalcRes()" onkeyup="javascript:CalcRes()" /></td></tr><tr><td class="k">'+i18n('Deuterium',9)+':</td><td class="k"><input size="12" id="tcDeut" value="'+AddCommas(ctDeut)+'"; onchange="javascript:CalcRes()" onkeyup="javascript:CalcRes()" /></td></tr>';
//TODO
// &nbsp;<a style="cursor:pointer" onclick="var ResTemp = document.getElementById(\'tcMetal\').value+\':\'+document.getElementById(\'tcCrystal\').value+\':\'+document.getElementById(\'tcDeut\').value; soSetCookie(\'soSet_ResTemp\',ResTemp)">&reg;</a>
//
tc.parentNode.insertBefore(tc_ntb, tc.nextSibling);
var as = xpaths('//a[contains(@href,"javascript:maxShip(")]');
for (var i = as.snapshotLength - 1; i >= 0; i--){
var a = as.snapshotItem(i);
if (a.parentNode.parentNode.getElementsByTagName('input')[3].value >= 500){
inp = a.parentNode.parentNode.getElementsByTagName('input');
inpnr = parseInt(inp[0].value);
inpcp = parseInt(inp[3].value);
inpin = inp[4].name;
var astar = a.parentNode.appendChild(document.createElement('span'));
astar.innerHTML = '(<a onclick="javascript:NeedShip('+inpnr+','+inpcp+',\''+inpin+'\'); document.getElementsByName(\''+inpin+'\')[0].focus();" style="cursor:pointer;">*</a>)';}}
sofGen_AddRefr('sofUpd_CargNeed', 300);}

function CalcRes(){
var metal = DelCommas(document.getElementById('tcMetal').value);
var kristal = DelCommas(document.getElementById('tcCrystal').value);
var deut = DelCommas(document.getElementById('tcDeut').value);
document.getElementById('resTotl').value = AddCommas(metal+kristal+deut);}

function Reset_CalcRes(ctMet,ctCry,ctDeut){
document.getElementById('tcMetal').value = AddCommas(ctMet);
document.getElementById('tcCrystal').value = AddCommas(ctCry);
document.getElementById('tcDeut').value = AddCommas(ctDeut);
document.getElementById('resTotl').value = AddCommas(ctMet+ctCry+ctDeut);}

function NeedShip(inpnr,inpcp,inpin){
var tempRess = DelCommas(document.getElementById('resTotl').value);
neededShips = Math.ceil(tempRess / inpcp);
if (neededShips > inpnr) neededShips = inpnr;
document.getElementsByName(inpin)[0].value = neededShips;}

function sofUpd_CargNeed(){
var cargosNeeded = document.getElementById('CargosNeeded');
var resursi = DelCommas(document.getElementById('resTotl').value);
if (! cargosNeeded) return;
if (resursi < 1){
cargosNeeded.innerHTML  = '<span style="color: '+soSet['soGen_impC']+';">' + i18n('Impossible',15) + ', ' + i18n('there is no resources.',13) + '</span>';
return;}
var capacity = 0;
var inputs = xpaths('//th/input[starts-with(@name,"ship")]');
for (var i = inputs.snapshotLength - 1; i >= 0; i--){
var input = inputs.snapshotItem(i);
if ((input.name != 'ship210') && (! isNaN(parseInt(input.value))))
capacity += parseInt(input.parentNode.previousSibling.previousSibling.previousSibling.value) * parseInt(input.value);}
var ship = document.getElementsByName('maxship202');
var MaxSmallCargo    = parseInt((ship.length > 0 ? ship[0].value - document.getElementsByName('ship202')[0].value : 0));
var ship = document.getElementsByName('maxship203');
var MaxLargeCargo    = parseInt((ship.length > 0 ? ship[0].value - document.getElementsByName('ship203')[0].value : 0));
var SmallCargoNeeded = Math.ceil((resursi - capacity) / 5000);
var LargeCargoNeeded = Math.ceil((resursi - capacity) / 25000);
if ((SmallCargoNeeded > 0) && (MaxSmallCargo < 1))
var SmallCargoNeededLink = '<span style="color: ' +soSet['soGen_impC']+ ';">' + AddCommas(SmallCargoNeeded) + ' ' + i18n('SC',41) + '</span>';
else if (SmallCargoNeeded > 0)
var SmallCargoNeededLink = '<a style="cursor:pointer;color: ' + (MaxSmallCargo >= SmallCargoNeeded ? soSet['soFlt_CargNeedC'] : soSet['soGen_notEnC']) + ';" onclick="javascript: var input = document.getElementsByName(\'ship202\')[0]; input.value = \'' + Math.min(MaxSmallCargo, SmallCargoNeeded) + '\'; input.focus(); return undefined;">' + AddCommas(SmallCargoNeeded) + ' ' + i18n('SC',41) + '</a>';
if ((LargeCargoNeeded > 0) && (MaxLargeCargo < 1))
var LargeCargoNeededLink = '<span style="color: ' + soSet['soGen_impC'] + '">' + AddCommas(LargeCargoNeeded) + ' ' + i18n('LC',17) + '</span>';
else if (LargeCargoNeeded > 0)
var LargeCargoNeededLink = '<a style="cursor:pointer;color: ' + (MaxLargeCargo >= LargeCargoNeeded ? soSet['soFlt_CargNeedC'] : soSet['soGen_notEnC']) + ';" onclick="javascript: var input = document.getElementsByName(\'ship203\')[0]; input.value = \'' + Math.min(MaxLargeCargo, LargeCargoNeeded) + '\'; input.focus(); return undefined;">' + AddCommas(LargeCargoNeeded) + ' ' + i18n('LC',17) + '</a>';
cargosNeeded.innerHTML = '';
if (SmallCargoNeeded > 0)
cargosNeeded.innerHTML += SmallCargoNeededLink + '&nbsp;&nbsp;' + i18n('or',29) + '&nbsp;&nbsp;' + LargeCargoNeededLink;}

function sofFlt_Fl1(){
var FI1 = xpath('//table[@width="519"]/tbody/tr/td/table/tbody/tr[1]');
var flot = FI1.childNodes[0];
var flote = flot.innerHTML.match(/\d+/g);
var diff = flote[1]-flote[0];
var color = 'lime';
switch (diff){
case 0:
color = 'red'; break;
case 1:
color = 'orange'; break;
case 2:
color = '#FDDA00'; break;
case 3:
color = '#CCFF00';}
flot.setAttribute('style','color:'+color+';background-color:transparent;font-weight:bold');}

function sofFlt_SpdSel(indx){
var speedsel = xpath('//tr[@height="20"]/th/select[@name="speed"][1]');
speedsel.value = (1+indx);
for (var i = 9; i >= 0; i--){
if (indx != i) document.getElementById('spdsel'+i).style.color = 'inherit';
else document.getElementById('spdsel'+i).style.color = 'red';}
shortInfo();}

function sofFlt_Fl2(){
if(soSet['soFlt_SpdSel'] > 0){
var spdsel = xpath('//select[@name="speed"][1]');
switch (soSet['soFlt_SpdSel']){
case 1:
spdsel.parentNode.setAttribute('style', 'text-align: right'); break;
case 2:
spdsel.parentNode.setAttribute('style', 'text-align: left'); break;
case 3:
for (var i = 9; i >= 0; i--){
var a = document.createElement('span');
a.innerHTML = '<a id="spdsel'+i+'" href="#" style="cursor:pointer;color:'+(i == 9 ? 'red' : 'inherit')+'" onclick="sofFlt_SpdSel('+i+')">'+(i*10+10) + '</a>  ';
spdsel.parentNode.insertBefore(a, spdsel);}
spdsel.style.display = 'none';}}
if(soSet['soFlt_ExpShrt']){
var table = xpath('//div[@id="content"]/center/center/table[@width="519"]/tbody');
var nwTr = table.insertBefore(document.createElement('tr'), table.lastChild);
nwTr.height= '20';
nwTr.innerHTML = '<th colspan="2"><a style="cursor:pointer" onclick="var planet = document.getElementsByName(\'planet\'); if (planet.length > 0) { planet[0].value = \'16\'; shortInfo(); }">' + i18n('Expedition',12) + ' (' + i18n('Outer Space',30) + ')</a></th>';}
if(soFlt_Scs.length > 0){
try{var table = xpath('//div[@id="content"]/center/center/table[@width="519"]/tbody');
for (var j = 1; j < soFlt_Scs.length; j++){
var newTr = table.insertBefore(document.createElement('tr'), table.lastChild);
newTr.style.display = (j%2 == 0 ? 'none' : '');
newTr.height= '20';
newTr.innerHTML = '<th><a href="javascript:setTarget('+soFlt_Scs[j][0]+','+soFlt_Scs[j][1]+','+soFlt_Scs[j][2]+','+soFlt_Scs[j][3]+'); shortInfo()">'+soFlt_Scs[j][4]+(soFlt_Scs[j][3] == 3 ? ' ('+i18n('Moon',28)+')' : '')+(soFlt_Scs[j][3] == 2 ? ' ('+i18n('Debris field',8)+')' : '')+' '+soFlt_Scs[j][0]+':'+soFlt_Scs[j][1]+':'+soFlt_Scs[j][2]+'</a></th><th>'+(soFlt_Scs[j+1] ? '<a href="javascript:setTarget('+soFlt_Scs[j+1][0]+','+soFlt_Scs[j+1][1]+','+soFlt_Scs[j+1][2]+','+soFlt_Scs[j+1][3]+'); shortInfo()">'+soFlt_Scs[j+1][4]+(soFlt_Scs[j+1][3] == 3 ? ' ('+i18n('Moon',28)+')' : '')+(soFlt_Scs[j+1][3] == 2 ? ' ('+i18n('Debris field',8)+')' : '')+' '+soFlt_Scs[j+1][0]+':'+soFlt_Scs[j+1][1]+':'+soFlt_Scs[j+1][2]+'</a>' : '')+'</th>';}}
catch(err){}}
if(soSet['soFlt_DefCrds'] != ''){
var defcrds = soSet['soFlt_DefCrds'].split(':');
var sbmt = xpath('//tr[@height="20"]/th[@colspan="2"]/input[@type="submit"]');
var sbmtnw = document.createElement('span');
sbmtnw.innerHTML = ' <input type="button" title="['+defcrds[0]+':'+defcrds[1]+':'+defcrds[2]+'] ('+i18n('Planet',32)+')" onclick="javascript:setTarget('+defcrds[0]+','+defcrds[1]+','+defcrds[2]+',1); shortInfo(); document.forms[0].submit()" value="'+i18n('Planet',32)+'" /> '+(defcrds[3] == 3 ? '<input type="button" title="['+defcrds[0]+':'+defcrds[1]+':'+defcrds[2]+'] ('+i18n('Moon',28)+')" onclick="javascript:setTarget('+defcrds[0]+','+defcrds[1]+','+defcrds[2]+',3); shortInfo(); document.forms[0].submit()" value="'+i18n('Moon',28)+'" /> ' : '')+(defcrds[3] == 2 ? '<input type="button" title="['+defcrds[0]+':'+defcrds[1]+':'+defcrds[2]+'] ('+i18n('Debris field',8)+')" onclick="javascript:setTarget('+defcrds[0]+','+defcrds[1]+','+defcrds[2]+',2); shortInfo(); document.forms[0].submit()" value="'+i18n('Debris field',8)+'" /> ' : '');
sbmt.parentNode.insertBefore(sbmtnw,sbmt);}}

function sofFlt_CalcCons(time){
var deutCost = 0;
for (var i = 220; i >= 200; i--){
var shipcount = document.getElementsByName('ship' + i)[0];
if (shipcount){
var sCons = document.getElementsByName('consumption' + i)[0];
deutCost += shipcount.value*sCons.value/10;}}
var hCons = Math.floor(time*deutCost);
if (hCons == 0) hCons = 1;
document.getElementById('ExpHoldingTime').innerHTML = tsdpkt(consumption()+hCons);}

function nullResources(){
for (i = 3; i >= 1; i--){
document.getElementsByName('resource'+[i])[0].value = 0;}
calculateTransportCapacity();}

function savedResources(){
var resTemp = soGetCookie('soSet_ResTemp').split(':');
for (i = 0; i < 3; i++){
document.getElementsByName('resource'+[i+1])[0].value = DelCommas(resTemp[i]);}
calculateTransportCapacity();}

function sofFlt_Fl3(){
if(soSet['soFlt_Impr']){
var inpt = xpath('//input[@name="order"]');
var inplab = inpt.parentNode.parentNode.parentNode;
inputs = inplab.getElementsByTagName('input');
for (var i = inputs.length-1; i >= 0; i--){
label = document.createElement('label');
label.appendChild(inputs[i].parentNode.removeChild(inputs[i].nextSibling));
inputs[i].parentNode.insertBefore(label, inputs[i].nextSibling);
inputs[i].setAttribute('id','InpId'+i);
label.setAttribute('for','InpId'+i);
label.setAttribute('style','cursor:pointer');}
var FI3 = xpath('//table[@width="259"]/tbody/tr[6]');
FI3.innerHTML = '<th>'+i18n('Resources',39)+'</th><th colspan="2"><a href="javascript:nullResources()">'+i18n('None',62)+'</a>&nbsp;-&nbsp;<a href="javascript:maxResources()">'+i18n('Max',24)+'</a></th>';}
//TODO
// '+(soGetCookie('soSet_ResTemp') ? '<a style="cursor:pointer" onclick="savedResources()">&reg;</a>&nbsp;-&nbsp;' : '')+'
//
if (soSet['soFlt_HoldCons']){
var selhld = xpath('//select[@name="holdingtime"]');
var selexp = xpath('//select[@name="expeditiontime"]');
var select = (selhld == -1 ? selhld : selexp);
if (select){
select.setAttribute('onChange','sofFlt_CalcCons(this.value);');
select.setAttribute('onFocus','sofFlt_CalcCons(this.value);');
select.parentNode.setAttribute('colSpan','2');
var th = document.createElement('th');
th.innerHTML = '<span id="ExpHoldingTime" style="color:lime"></span>'
select.parentNode.parentNode.appendChild(th);}}
if (soSet['soFlt_DefMis'] > 0){
var orders = xpaths('//input[@type="radio"][@name="order"]');
if (orders.snapshotLength == 1){orders.snapshotItem(0).checked = 'checked';return;}
var opt = soSet['soFlt_DefMisO'][0];
soSet['soFlt_DefMisO'][soSet['soFlt_DefMisO'].length] = -1;
if (opt == -1) return;
var order1 = xpath('//input[@type="radio"][@name="order"][@checked="checked"]');
if (order1) return;
i = 0;
while(opt != -1){
order = xpath('//input[@name="order"][@type="radio"][@value="'+opt+'"]');
if (order){
order.checked = 'checked';
return;}i++;
opt = soSet['soFlt_DefMisO'][i];}return;}}

//### MESSAGES ###

function sofMsg_MsgsC(){
var deleteSelect = document.getElementsByName('deletemessages');
if (deleteSelect.length < 1) return;
if (soSet['soMsg_Clear'])
deleteSelect[0].parentNode.parentNode.parentNode.parentNode.parentNode.style.backgroundColor = 'transparent';
var rows = deleteSelect[0].parentNode.parentNode.parentNode.childNodes;
for (var i = 0, row = ''; row = rows[i]; i++){
if ((row.childNodes.length < 1) || (row.firstChild.innerHTML.search(/delmes/i) == -1) || (rows[i+1].firstChild.colSpan == '4')) continue;
var color = '', bgColor = '';
if (rows[i+2].firstChild.innerHTML.search(/sneak/i) != -1){
if (row.lastChild.innerHTML.search(/<img/i) == -1){
if (soSet['soMsg_AllyReply'])
row.lastChild.innerHTML += ' <a href="index.php?page=allianzen&session='+session+'&a=17"><img alt="'+i18n('Reply',38)+'" title="'+i18n('Reply',38)+'" src="'+sofSys_GetSkinURL()+'/img/m.gif" /></a>';
color = soSet['soMsg_AllyC'];
bgColor = soSet['soMsg_AllyBgC'];}
else if (row.lastChild.innerHTML.search(/<img alt/i) == -1){
color = soSet['soMsg_PrivC'];
bgColor = soSet['soMsg_PrivBgC'];}}
else if (rows[i+1].firstChild.innerHTML.search(/delmes/i) == -1){
if ((row.lastChild.innerHTML.search(/(<span|<font)/i) == -1) && (rows[i+1].lastChild.innerHTML.search(/:\s*1?[0-9]{1,2}\s*%.?\s*$/i) != -1))
row.lastChild.innerHTML = '<span class="espionagereport">' + row.lastChild.innerHTML + '</span>';
if ((row.lastChild.innerHTML.search(/(<span|<font)/i) != -1) || (rows[i+1].lastChild.innerHTML.search(/<table/i) != -1)){
if (rows[i+1].lastChild.innerHTML.search(/<table/i) != -1) {
if ((row.lastChild.innerHTML.search(/espionagereport/i) != -1) && (soSet['soMsg_SpyRepC'])) continue;
else if (soSet['soMsg_MissRepC']){
row.lastChild.class = 'combatreport';
continue;}}
color = soSet['soMsg_ActiveC'];
bgColor = soSet['soMsg_ActiveBgC'];}
else if ((row.lastChild.innerHTML.search(/\[[0-9]+:[0-9]+:16\]/) != -1) || (rows[i+1].childNodes[1].innerHTML.search(/>\[[0-9]+:[0-9]+:16\]<\//) != -1)){
color = soSet['soMsg_ExpC'];
bgColor = soSet['soMsg_ExpBgC'];}
else{
color = soSet['soMsg_PassiveC'];
bgColor = soSet['soMsg_PassiveBgC'];}}
if (color != '')
rows[i+1].childNodes[1].style.color = color;
if (bgColor != '')
rows[i+1].childNodes[1].style.backgroundColor = bgColor;}}

function sofMsg_DelForm(){
var deleteSelect  = xpath('//select[@name="deletemessages"]');
var reportsInput  = xpath('//input[@name="fullreports"]');
if ((deleteSelect.length < 1) || (reportsInput.length < 1)) return;
var reportsTr = reportsInput.parentNode.parentNode;
var deleteTr = deleteSelect.parentNode.parentNode;
reportsInput.setAttribute('onchange', 'document.getElementsByName("fullreports")[1].checked = this.checked;');
deleteSelect.setAttribute('onchange', 'document.getElementsByName("deletemessages")[1].selectedIndex = this.selectedIndex;');
deleteSelect.parentNode.childNodes[3].setAttribute('onclick', 'this.parentNode.parentNode.parentNode.parentNode.firstChild.submit();');
var newReportsTr = reportsTr.cloneNode(true);
var newDeleteTr  = deleteTr.cloneNode(true);
newDeleteTr.id   = 'deleteFormTop';
reportsInput.setAttribute('onchange', 'document.getElementsByName("fullreports")[0].checked = this.checked;');
deleteSelect.setAttribute('onchange', 'document.getElementsByName("deletemessages")[0].selectedIndex = this.selectedIndex;');
deleteTr.parentNode.insertBefore(document.createElement('tr'), deleteTr.parentNode.childNodes[1]);
deleteTr.parentNode.insertBefore(newReportsTr, deleteTr.parentNode.childNodes[1]);
deleteTr.parentNode.insertBefore(newDeleteTr, deleteTr.parentNode.childNodes[1]);}

function sofMsg_SpyRep(){
var sprs = xpaths('//span[@class="espionagereport"]');
for (var i = sprs.snapshotLength - 1; i >= 0; i--){
var spr = sprs.snapshotItem(i);
var formn = spr.parentNode.parentNode.firstChild.firstChild.getAttribute('name');
var tables = spr.parentNode.parentNode.nextSibling.getElementsByTagName('td')[1];
if(soSet['soMsg_RepRes']){
var restd = tables.getElementsByTagName('td');
var metal = parseInt(restd[2].innerHTML.replace(/\./g ,''));
var crystal = parseInt(restd[4].innerHTML.replace(/\./g ,''));
var deut = parseInt(restd[6].innerHTML.replace(/\./g ,''));
var totmet = Math.round(metal/2);
var totcry = Math.round(crystal/2);
var totdeu = Math.round(deut/2);
if (totmet <= (totcry + totdeu)){
var LCn = Math.floor((totmet + totcry + totdeu + 24999) / 25000);
var SCn = Math.floor((totmet + totcry + totdeu + 4999) / 5000);}
else{
LCn = Math.floor(((totcry + totdeu) * 3) / 50000);
  tempm = totmet - Math.floor(LCn * (25000 / 3));
  tempm -= Math.min(16667 - Math.floor((totcry + totdeu - (LCn * (50000 / 3))) / 2), Math.floor(50000 / 3));
LCn += Math.floor((tempm + 33333) / (50000 / 3));
SCn = Math.floor(((totcry + totdeu) * 3) / 10000);
  tempm = totmet - Math.floor(SCn * (5000 / 3));
  tempm -= Math.min(3333 - Math.floor(totcry + totdeu - (SCn * (10000 / 3))), Math.floor(10000 / 3));
SCn += Math.floor((tempm + 6666) / (10000 / 3));}
var RepRes = '<table width="400" cellpadding="2"><tr><td class="c" colspan="4">' + i18n('Resources',39) + '</td></tr><tr><td>' + i18n('Total',55) + '</td><td>' + AddCommas(metal+crystal+deut) + '</td><td>' + i18n('Raid',37) + '</td><td>' + AddCommas(Math.floor(totmet+totcry+totdeu)) + '</td></tr><tr><td>' + i18n('Cargos',3) + ': ' + i18n('LC',17) + '</td><td>' + LCn + '</td><td>' + i18n('Cargos',3) + ': ' + i18n('SC',41) + '</td><td>' + SCn + '</td></tr></table>';
tables.innerHTML += RepRes;}
if(soSet['soMsg_RepEsp']){
var tblssrch = tables.innerHTML.match(/<TABLE width="400"><TBODY><TR><TD class="c" colspan="4">/g);
var proben = parseInt(tblssrch.length-1);
var probenum = (proben == 4 ? 5 : proben);
if (proben > 0 && proben < 5){
var RepEsp = '<table width="400" cellpadding="2"><tr><td class="c" colspan="4">'+i18n('Espionage',21)+'</td></tr><tr><td>'+i18n('Probes used',34)+':</td><td align="center"><input type="text" onKeyUp="if (this.value != ' + "''" + ') document.getElementById(' + "'prbsn" + formn + "'" + ').innerHTML = Math.max(7 + ( ((parseInt(this.value) - ' + probenum + ' + 0.1) / Math.abs(parseInt(this.value) - ' + probenum + ' + 0.1)) * Math.pow(Math.ceil(Math.sqrt(Math.abs(parseInt(this.value) - ' + probenum + '))), 2)), 1)' + '" size="3" maxlength="2" style="text-align:center"></td><td>'+i18n('Probes needed',35)+':</td><td align="center" id="prbsn' + formn + '"></td></tr></table>';
tables.innerHTML += RepEsp;}}
if(soSet['soMsg_RepLnk']){
var gServLan = sofGen_GetLang();
var ServLang = gServLan[0];
switch (gServLan[0]){
case 'es':
ServLang = 'sp'; break;
case 'se':
ServLang = 'sv';}
var RedRepRes = tables.innerHTML.replace(/<td\sclass\=\"c\".*?>/ig, '\n').replace(/<\/tr>/ig, '\n').replace(/<\/td>.*?<td>/ig, '\t').replace(/<.*?>/g, '');
RedRepRes = RedRepRes.replace(/\n\n/g, "\n").replace(/\n\n/g, '\n');

var dsServ = new Array('ba','bg','br','cz','de','dk','es','fr','gr','hu','it','kr','nl','pl','pt','ro','ru','sk','se','tr','tw','us');
var dsLang = new Array('bosnian','bulgarian','portuguese','czech','german','danish','spanish','french','greek','hungarian','italian','korean','dutch','polish','portuguese','romanian','russian','slovak','swedish','turkish','taiwanese','english');
var dslan = 'english';
for (var l = 21; l >= 0; l--){
if(Server.match(dsServ[l])){dslan = dsLang[l];}}

var el = document.createElement('form');
el.innerHTML = '<input type="hidden" name="report" value="'+encodeURI(RedRepRes)+'" />';
el.method = 'post';
el.target = '_speedsim';
el.id = el.name = 'speedsim_form'+formn;
el.action = 'http://websim.speedsim.net/index.php?lang='+ServLang;
document.body.appendChild(el);
var linkdosim = '<br /><center><a style="cursor:pointer;padding:2px;font-weight:bold" title="SpeedSim" onclick="document.getElementById(\'speedsim_form'+formn+'\').submit();">SpeedSim</a> <a style="padding:2px;font-weight:bold" title="DragoSim" href="http://drago-sim.com/index.php?lang='+dslan+'&referrer=drago-script&scan='+encodeURI(RedRepRes)+'" target="blank">DragoSim</a></center><br />'
tables.innerHTML += linkdosim;}}}

function sofMsg_InsSml(smilie){
document.getElementsByName('text')[0].focus();
var sel = document.selection.createRange();
sel.text = smilie;}

function sofMsg_Sgnt(){
xpath('//textarea[@name="text"]').innerHTML += ((soSet['soMsg_Sgnt'] != '') ? '\n\n\n'+soSet['soMsg_Sgnt'] : '');}

function sofMsg_Sml(){

var smilt = new Array('^_^',':S',':lol:',':|',':rotfl:',':P','O.O','O.o','&gt;_&lt;',':&lt;',':&gt;','8-)',';(',':(','xD',':D',';)',':)');
var smilg = new Array('data:image/gif;base64,R0lGODlhFAAUAIQdAP/mIFVACP/iHPrWDEA0EPbOAP/aEOqqAPbKAPK2AOaZAG1QBPK+APrSBP/eFKVtBPLCAO6yAFlACNquALKJAP/eGKp9BMqNAJllAM6FALp1APbOBM6ZAP///////////yH5BAEKAB8ALAAAAAAUABQAAAW74CeOZGmaQaqeZbBQEwJN1hKwX2Btg2EMDQQDczNJOAOHYClwDAqMi6RFGVQEgGxW8ExYiqJFQ0kgaMuVBuOwGAWqAjPALCcYEJFHMTAxYLWAAAYFCRd7CH6BgA6ECnsQA3+KgniOInwNFZMAXBAHGXsUCJGKAoMJB3ojCwwFAwR/AhWDawptbhatDWUOP1ARCqokEhcJEAgFBTKoChpTKBgHEQkJEQcHCkQ4Lg8XCgoZDzY4biop5OgmIQA7',
'data:image/gif;base64,R0lGODlhFAAUAKUxAAAAAHhkPGBIFGxQBKx8ANisAPTAAHBcMJh0BPTMAPjUDP/YEPjQCPTIAOy4AGhQHNCkAP/cFP/cGP/gHP/gGPjYDPjMAPC4ALyEAAAACP/kIPC0AKRwBHBQBOyoAGxIBPjYEOysAHBgNNCMAPDEAP/YFOCQAGRMHPjUCHRkOOigAKRoAP/kHOSYAPDAAJRkBFxIFP///////////////////////////////////////////////////////////yH5BAEAAD8ALAEAAQATABIAAAbDwJ9wmEoJBMWhUpkaEAoWQ4HwSS2HB4QFFbF0LQ7E4SoocCOTSWQNxgiYmPUkA9Bo1KgowSr8eCMZdoEaAF0OHh9CKXGAGhmDgl0eK1YHBWuCkI8AYCYBPwIOaHakmZImbwJbEaWlagkeLTA/lhYTAHWtESiHI58pBAlyuXavDiovfB8OwmgAaWyHJomKBMx/uBEJhyqUSgIYHswJCWAeKioEJ1cHLx7vh+8mL2NXPykfLyMtKhgvVfaYpIAB4wCfJUEAADs%3D',
'data:image/gif;base64,R0lGODlhFAAUAKU2AEA0EFVACP/mIG1MBI1dAJ0AAPraEP8AAKVxBP/iHFlACPrWDPbKAPK2APLGAOadAN6VAHFVBPK+AKVpBPbOBLKNAM6NAMKNAP/eGPrSCG1QBO66ALp1AOKVAJVhBMqlAJ19BOqqAMqFANauAOalAK6FAPbCAK59APbGAKVtAJlxBN6uAOaZAJlpBNalAKp1BO6yAM6FAK6JBK6BBN62AP/eFP///////////////////////////////////////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQJDQA/ACwAAAAAFAAUAAAGv8CfcEgo/ghH5HDJFBaVyuYyQK1KmYGIbIRyuGaawPUXAFEWBsMiw9ioxE3FB0BP2OkAyUWBrQAwCQIAggIGDAANL3BCERSAApCRhRkmIQNDARULgZKRaQwwCHABNAYIA3ipAAMIDRajDgiqswAIELCotKkDt0IBK7m6dAMxoyWywnQIKYsREngFBwDRBXgdl5gnzwAH3d50DxOLQgoXDdMF6ekADxx8TQEtJMGrEB7jWKwWDywiEwP4pFSx0iQIACH5BAEKAD8ALAEAAAASABQAAAa8wJ9w+CMUiwQjcSlMKpnLgHQKHQYishHK4ZppAtAAiLIwGBYZxkYFJio+ixomQccYGJKLwlpZAP4CgX8ADA0vbREUAAmCAgCBBgAmIQM/AX2MgZqQdzAIUjQGmZuchRZSDgYIA4OtAAMIDRCoCK62AAizASust60DMVIltb6DCClgERK9BQcAzQV/Ax2VlicSfwfa238PE20/ChcNzwXm5gAPHHtEAS0kvdIQHuDtsBYPLCITA/VMU1SWBAEAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUANUHAFVACP/mIEA0EP/iHP/aEPbKAP/ykf////K2APbGAPrWDOqqAG1QBOaZAKVxBK6FAO6yAPK+AP/eGPrSBP/eFP/ylVlACMqNAM6FANaqAPbOBN6yAJltBJllALp1AM6ZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH+HUJ1aWx0IHdpdGggR0lGIE1vdmllIEdlYXIgNC4wACH5BAkAACAALAAAAAAUABQAAAbSQJBwSCwajYCk8lgEMB6ZRCLzYACYIIBDoyAQFJMCgnM1Wj4EymA9EAgKkYul+SBI3IKAvi12lIUME2oBBgaEhhITCQsMQwAPCgMBB24BbgcDBAUQfkIAGwQDBpR5lwaaCBdlAAmhowcHk7AGFGINqwmRhxUBFb4BmhC3nhsTEnrIyAMKixirDwW6yQGZYgudgBHREpLUEgQaEQsNjY4P2hNeFF9wwtiOFwgJBQVuCQjjHnNIHAsQCAggLBjX4Q8SBg4wNGiAwYEVLI6UJIFI0UgQADs%3D',
'data:image/gif;base64,R0lGODlhFAAUAKUEAEA0EP/mINLu///iHP///1VACPraEPbKAPrWDP/eGPK2AP/aFPK+AO6yAFlACHFVBG1MBPbGAPrOBKVpBPbCAK6BBLKNAPrSBOaZAO6qAOqhAMqlAPLGAN6VAPLCAOadAJ19BOqqAKVxBK6JBMKNAM6NANauALp1AO66AMqFAO6uAN6uAJVhBNalAOKVAOalAKp1BJlxBM6FAN62AJlpBP///////////////////////////////////////////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFCgA/ACwAAAAAFAAUAAAGysCfcEgsGo2FJKAAOBYLD4IU0Ko8Cs5fQcDlAi4HVAxrdHS7gIQBwCA5noC4PD5YHxQwsvAhAUj/AAEDAAgUIRBDBRYIg2eBAQAGBw0iZAUzBgONXpAGkgollhyZAZBypQYJdx2ijIKvpQFqk6xCBSsXCQOxvAuFGTKWFQeZu7x1BwwaE3oPDMS6ggO6CwwhGIiJFc8InmoIBx4qH8xFDiQKzwfrFAoZGCdvSDQvDQoKDRkaLix6SBAiSnzAkGICBH9OkihEmKXhkCAAIfkEBRQAPwAsAwABAAsAEAAABkXAn/BXKBqHwpEpEkH+QBKAFIDcIACErBBwsCB+Wa1TQCYjp2jqNhwWDqRs8bZcVv8AdDL1nZ5u73FqgnSCQ3h6d05oQ0EAIfkEBQoAPwAsAwABAAsAEAAABlXAn3D4AxSJP4LSSBQ4ncjnUzgAWK9XpHJLRAx+UqJhUJ0WDeNAADv0BgZvtfp3ScDl8sVhfJf/DD97dm9fPwtCBwhoCYA/HkMMB5IHPwpIDQoKDUNBACH5BAEUAD8ALAMAAQALAAkAAAY4wJ/wVygah8KRKRJB/kAShMGAQG4Qi8RgkEggDhaENrANCA8/7YAcaP8Wv/J63YYL23j3PY//BQEAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAKU4AEAUEJEEBEA0EPoEBFVACFlACG1MBG1QBHFVBI1dAJVhBJlpBKVpBKVtAJlxBKVxBKp1BJ19BLp1AK6BBK6FAMqFALKNAM6FAMKJAM6JAMKNAM6NAN6VAOKVAOaZAMqlAOadAOqhAOalAOqqAN6uAO6qAO6uAN62AO6yAPK2AO66APK+APLCAPLGAPbGAPbKAPbOBPrSCPrWDPraEP/aFP/eGP/iHP/mIP///////////////////////////////yH5BAEKAD8ALAAAAAAUABQAAAbNwJ9w+EsMjcSk0shEKpOEqPQJRQAAruvkQKD+CBEADicmqxxdZeEjvrrJK00BapG13e1XCpIWImA1ZWRjZDEsIwZDBHU2N26OVzQzLygPaQQnM403nJ03NDR6G5ctmp6eoHoclywyNgKnnAKTKKtCBCQxNTcCeAACNDIsJReXFC+mv8o2oSkhDX0IK8g1AQPWATYvKyUdiYoT0zHY19smIAx9QgUYKSzWA9cpJSASc0oECyIoAf0lIRwUqINi4EEGEB4qMDAw8ImUKUqCAAA7',
'data:image/gif;base64,R0lGODlhFAAUAKUAAP///wAAAAgICP/mIFVACP/iHPraEPbKAPrWDP/eGCAgIPK+AFlACPK2AHFQBPbCAG1MBOqqAPrSBKVpBOadAO6yAN6VAPrOBP/aFNaqAOaZAPLGAMKNAKVxBN6yAPbGALKNAK59AM6NAOqhAJltBLp1AO66AK6FAO6uAMqlAPLCAJ19BOalAJVhBM6FAMqFAK6JBKp1BP///////////////////////////////////////////////////////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAA/ACwAAAAAFAAUAAAGs8CfcEgsGo2EpPJYJDhgmc8nE3IQmD/CKsA1ICTcwNXISAUA6EDhnGY0QWw0IJ4eCx10uT49JMDleXFiQgQeeXuAYwQbBgJ7jnoBFoobCGuAA5BzFZOEHhIJBQIKAQOmCgIBDxEuiicHBgUFprQFBgcLIxN2DguwoaYFoQkLERoQRAQhvhIGBgleuCgUu0UMHA0qB2EBxRQlbkgkLBXcIxYtdkgQHSIUGi8TEOpMSktY+EdBACH5BAUPAD8ALAwACQAEAAMAAAYMwN9PQBQYDgMD4hcEACH5BAUPAD8ALAwACQAEAAMAAAYKQIBwCAgoBIFfEAAh+QQFDwA/ACwMAAkABAADAAAGDMDfT0AUGA4DA+IXBAAh+QQFyAA/ACwMAAkABAADAAAGCkCAcAgIKASBXxAAIfkEBQ8APwAsBQAJAAsAAwAABhBAgeBHLBYHA6GROEQ6k8ogACH5BAVkAD8ALAUACQALAAMAAAYSQIBQ+CsaA0Pj8SdQBIyK3zMIACH5BAUPAD8ALAUACQALAAcAAAYYQIHgRywWBwOhkThEOpPKpXS6TFCLBmoQACH5BAVkAD8ALAUACQALAAcAAAYbQIBQ+CsaA0Pj8SdQBIyK31NJrVp/kqvxcA0CACH5BAUKAD8ALAMAAwAPAAkAAAZDwJ/wgjAYhAcTSchECJ6FQiJA5TQFTAGVGYj9LljmLyAeQ5zldKBjCHPLAtGv4H6ShYEGc/AUDP5UAQdlf4V/BghMQQAh+QQFDwA/ACwEAAQADQAHAAAGMsDfD5MoGH+Iw0L4Kw6MT8Ph0GhCC4NsAYN4RAJgcDYMrkCz6IEhQf2l0wmpUPs2GIRBACH5BAEKAD8ALAQABAANAAcAAAYpwN9PQBT+AkijAMAUIJmAwBDKDFCjS8DvusVerVTBtOmESoVEsRB5DgIAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAKUCAEA0EP/mIP/////iHFVACPraEPbKAP/eGP/aFPrWDPK2APLCAPK+AFlACG1MBO6yAJltBKVpBO6qAPrSBOaZAPbGAK59APrOBMKNAPLGAHFQBKVxBOqhAOadAG1QBN6VAOqqALKNAN6yAM6NAOKVAO66AO6uAMqlAOalAK6JBNauAM6FAK6FAKp1BLp1AMqFAJ19BNalAP///////////////////////////////////////////////////////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFLAE/ACwAAAAAFAAUAAAGzMCfcEgsGo2EpPJYJHhSqkolZvEQmD8C7JIoFBITQwlyNTZOCcRhMDgcEgYGptEMJQ6A/CAwKBgMCi1lQhoXeAKIAAF5AAkLIA5DBHYAiJaViQYPG2UEIgWYiQKYAIAjnRmglqKZCh+oCQOhiox+D69CnhNrjAG+AV8LEiudLAYFbL++AwhxHBGDGgzHa8trCAwgFJGSFtMTXnilCyYd0EUNGAoLf38LChIULnRIECgPCgoPEhwkZFgEHGwY0YHCiwgOBgFUkgSLQyZBAAAh+QQFCgA/ACwEAAUACwAHAAAGKMDfbxAYDITIIZEYKCKUxWizUBgAroAAFoBgNr+BwuEX9QbGQvBXGAQAIfkEBWQAPwAsBAAFAAsABwAABiDA3w9AFBqFAIESMCwmlUsoESpI/pZPqXS4JTKRxeMvCAAh+QQFCgA/ACwEAAUACwAHAAAGKMDfbxAYDITIIZEYKCKUxWizUBgAroAAFoBgNr+BwuEX9QbGQvBXGAQAIfkEBQoAPwAsBAAFAAsABwAABiDA3w9AFBqFAIESMCwmlUsoESpI/pZPqXS4JTKRxeMvCAAh+QQBCgA/ACwEAAUACwAHAAAGKMDfbxAYDITIIZEYKCKUxWizUBgAroAAFoBgNr+BwuEX9QbGQvBXGAQAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAPQfANGRBv/iHJRtDNitDumoAOjCBfS4AG1UCP3dF//qIVdACAAAAP/mH//yKP/uJvrXDPPNA5qKC/3RAvzCAv7xBN6XAv/fCv3oCeayAPfTCvbFAP7NAf/yHMGrD/fUBv///yH5BAEAAB8ALAAAAAAUABQAAAW14CeOZGmaSqqepXJEhSQNwqGwn3tdScJYkontpOhQGg1HjxF4aAA3kiJyRCp9AYTEIIiKDsfF4spgiJ2Gw2hadSyWi+wDQuiKFAVOMiE2xxFOGFB3D0lKfWJZGQUEFVEKHglXPmVMCBCMjncFF2SVAU0FGBWDOREWS5UMCJeMAHZfGxZlYrWYgqV3EbJ/gBALo69edx0TEg8PGbcVFbAtBxMG0RiNFUMsLgID1MLD2CopOOIsIQA7',
'data:image/gif;base64,R0lGODlhFAAUAKUzAAAAAPf3797fxnhkPGBIFM7PpWxQBKx8ANisAPTAAK2ue/TMAPjUDP/YEPjQCPTIAGNhOf/cFP/cGP/gHP/gGPjYDP/kIHBQBPjMAOyoAGxIBLyEAP8AAPjYEOysAKRwBHBgNPC0ANCMAPDEAP/kHP/YFOCQAGRMHPjUCHRkOPC4AOigAKRoAOSYAPDAAGhQHHBcMJRkBFxIFP///////////////////////////////////////////////////yH5BAEAAD8ALAEAAAASABQAAAbXQIDwRywaf0IAMqA8HgFMpGD4S6UIBCsSMEUWCkLDAYFJIA7CrxLwVQAwqAhGjgEo1FsFBBCJTCZ9EQAQbk1JQn8WFoKHKUQXcyRCihZCESgJGRpVG3EAHJNCoHIZLFYIfZ+glRygKBgqIikyKhGKk7cAJKQrWAsYE5TCixELGSYnMKh9w4qXKhmyKQcLKInCfQsqKzGOGipzjEnF0CabVQcqC3yXqdAtpkUyGyrqC/f1GSsHBEcwMSsyZICmz0QMGE6qaIghokWLDTE0OEpIxIoMGVqOBAEAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAKUqAAAAAPf3797fxnhkPGBIFM7PpWxQBKx8ANisAPTAAK2ue/TMAPjUDP/YEPjQCPTIAGNhOf/cFP/cGP/gHP/gGPjYDP/kIHBQBPjMAOyoAGxIBLyEAP8AAPjYEOysAKRwBHBgNPC0ANCMAPDEAP/kHP/YFOCQAGRMHDkgAHRkOP//////7/C4AOigAKRoAOSYAPDAAGhQHHBcMJRkBFxIFP///////////////////////////////////////////yH5BAEAAD8ALAEAAAASABQAAAbXQIDwRywaf0IAcqU8HgFMpGD4S6UIBCsSMEUWCkLDAYFJIA7CrxLwVQAwlQhGjgEo1FsFBBCJTCZ9EQAQbk1JQn8WFoKHKUQXcyRCihZCERUJGRpVG3EAHJNCoBUYGS4pMgh9n6CVHKByLCIpNAkRJJUAlJZyGS1YCxgTlMQWgAsZJiepdSjFikIsGbMpB3Uqh0nYLC2nPxosACrj5OQAyZtVBwlC5djnLTOORAQbLOGH0i8bBEcyMxky3AvYwsQMGU6qaHAhokWLDS40zEtYhRYNGROLBAEAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAKU+AFdACK+KBNeuAvXHAKyBBJ99BPTMBvzZEfvXDvrSB+25AJpwBFtDCMukAv3cFv7fGv3dF/jMAPK9AMKMAltCCAAAAN+0AfC2AP/mI9+XAPbKAO+yAN6uAf/kIfrUCvTDAPfMAOmiAHFTB/G8AP7hHf7iHvO/AOOVAG9NB/zbFPvaEUMXEO2uAOecAMKLAuyqALt3AphrBOemAOCTAJViBKZxBMyLAuaZAMqEAqRrBGxLB4GysoCAgPPCAP///////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFlgA/ACwAAAAAFAAUAAAGxsCfcEgsGo2ipPJYFC0agoNBEIiJmD9RweCApA4IhIJwRVpKpEep83AgDCZbeSiaOB6dvF7qGbnmPysVg4SFhnSGiYZlIhaJGIkmGQxCDB6PiRctjFyGkIUGG5OVHAkkGKipqF4fL3JCIgEGB3gdqiUOAxchNTp0IxEIanklDyQOJiwnNEQiBBIGCQcHDioeKxIsLTmURBQuGx8DK+QrFy8tMIB0CzIbFxcbLyEzNBRYADo1Njc3ODko1h0RQQGAQQBYEjIJAgAh+QQFCgA/ACwIAA0ABgADAAAGCsCfULgaDjUaYxAAIfkEBQoAPwAsBAANAAoAAwAABhPAn3A4dAhXxJ/mt+P9VtBVTxgEACH5BAkKAD8ALAEADwAKAAQAAAYRwJ/QtRH+QAOj0rjbLZlPYxAAIfkEAQoAPwAsAQABABIAEgAABrzAn3AoKhqHSOKiITgYBIGYKCkUFQwOSOqAQCgIU6TIUiI9Sp2HA2Ew2cI/0cTx6NjvTs/IFV5V/oCBgnGChYJFFoUYhSYZDAweioUXLUVYgouBBhuODBwJJBiio6JaHy9vIgEGB3UdpCUOAxchNTpxIxEIZ3YlDyQOJiwnNFUEEgYJBwcOKh4aEiwtOQxDFC4bHwMr3CsjLy0wcFULMhsXFxsvITM0FFQ/ADo1Njc3ODko41QiFAD/AKgEAQA7',
'data:image/gif;base64,R0lGODlhFAAUAIQfAPTDAKt0BBud5tesAvnQBeupAJ13BPvaEq+HA5ZmBOedAMyFAm54SuCWAM6MAt/ZOUWluaRrA8KMA4KwePK9AO+xAPC2APzZEf3eGPvXDvbKAEolAP7iHv/mImJMF////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAAfACwAAAAAFAAUAAAFsuAnjmRpml6qnmWKDBowICn7eQaRHVdGaBWD5+QZ7DAcDgbjo0iGJA8ig0x2OsmMxhKAijyEKnaszAAKXimVc21fOdpK9zu4sO9t9mXrgHo0dmxubRcEFg1+ABlWGxtXjRwHQIh0YRyOgxtmBQt+CIBJgm+SFAoRaRSAYkqFFAWUI1KpBBeNjQQUFaZeXxIWABsawsAFCnMoCQUVFhYVxQ0JvC0eEQ4KCgun0kQqNTbfJyEAIfkEBQoAHwAsBQAMAAMAAwAABQigIDzQ+GVfCAAh+QQFCgAfACwEAAwABAADAAAFCeDBjZOAcSXxhQAh+QQFCgAfACwDAAwAAwAFAAAFDOB3fZ92GRD0CerHhAAh+QQJCgAfACwDAA4ABAAEAAAFDCBCad+HWOUnKGoZAgAh+QQFZAAfACwDAA4ABAAEAAAFDSBCaYQnWcDnJcWneiEAIfkEBQoAHwAsBAAJAAsACQAABSbgJ27bWIrf1nXien4dh4ockbVzbpL6m+aGD0EU0RlRgU9DlPyEAAAh+QQFCgAfACwEAAkACwAJAAAFJ+Andt1Yil+3beLKodsJZ5f4ojjKdRyWfzUUIcfStH5IVOSjEC0/IQAh+QQFCgAfACwEAAkACwAJAAAFJuAnbttYit/WdeJ6fh2HihyRtXNukvqb5oYPQRTRGVGBT0OU/IQAACH5BAUKAB8ALAQACQALAAkAAAUn4Cd23ViKX7dt4sqh2wlnl/iiOMp1HJZ/NRQhx9K0fkhU5KMQLT8hACH5BAUKAB8ALAQACQALAAkAAAUm4Cdu21iK39Z14np+HYeKHJG1c26S+pvmhg9BFNEZUYFPQ5T8hAAAIfkEBQoAHwAsBAAJAAsACQAABSfgJ3bdWIpft23iyqHbCWeX+KI4ynUcln81FCHH0rR+SFTkoxAtPyEAIfkEAQoAHwAsBAAJAAsACQAABSbgJ27bWIrf1nXien4dh4ockbVzbpL6m+aGD0EU0RlRgU9DlPyEAAA7',
'data:image/gif;base64,R0lGODlhFAAUAMQAAP/mIFVACPraECwkCPK6AP/iHPbOAPLCAEA0EOqqAG1QBOaZAPbKAKVtBP/aFO6yAFlACPrWDPrSBLKJAKp9BP/eGMqNAJllAN6yANaqAM6FALp1APbOBM6ZAAAAAAAAACH+HUJ1aWx0IHdpdGggR0lGIE1vdmllIEdlYXIgNC4wACH5BAkAAB4ALAAAAAAUABQAAAW1oCeOZGmaQaqeZaBMGXNklBKwXkBxkeBLDMLlZoJ0BI5BYTkQGA4WSGsiqAwAWGzTQKAQRQqJNUseSA4JxSgwiRS02WtBwHg0iAGM4A24wgEOXBZ4B3t/fViBBAuEhmRkdA+MInlij1kFEWgaeBMMjmRzXAl3IwoEBlUIq6xPCQtqaxSoCEgOAhEGCJKlJBAWBAcMBgYyBK8bUigXCQ8EBA8Jr0M4Lg0WCwsaDTY4ayop3uImIQA7',
'data:image/gif;base64,R0lGODlhFAAUAIQbAAAAAHRkOGBIFGxQBKx8ANisAPjMAPTAAGxIBHBcMJh0BPjYDP/cFOy4AP/gHLyEAPjUDP/kIOyoAKRoAPTMAOSYAHhkPOCQAGRMHDkgANCMAP///+igAJRkBFxIFP///yH5BAEAAB8ALAEAAQASABIAAAWx4CeOQSAI5aiSA1EYRkEgwSomirEwBm80isTKU9gxjsjfw0N67AAORyTCACwMB0Ltg+gxIoAp+PiTID6BB3IaDlN5kkkgUThK3eApnJPwNI55YmMMFA0XJzpfgmJHDRKHdAYAGYtsAAYSGiUEkhsAn6AAng0cclwNohuqq6oAj2doBAefrJ6uHB1bHx4PB6ihjhxLKwkdHBIHEsocFx1CNgEIExocwhM0NiolHh4JuiMhADs%3D',
'data:image/gif;base64,R0lGODlhFAAUAKUEAEA0EFVACP/iKNLu//////rWDPraJFlACG1MBP/iHPLGAHFVBLKNAO62AM6FAN6VAP/mIPbOBPLGHP/aEMKJAOKREO66HPbGAKVpAPrOAKVxBOaVEO6yGK6BBN6yAP/eGOaZAOalFKp1BJVhBNauAP/eFMqFAPbOINalAJlxBPK6ALp1AG1QBK6FAOqqAMqZAKVtAJlpBJ19BP///////////////////////////////////////////////////yH5BAEKAD8ALAAAAAAUABQAAAaxwJ9wSCwajYGk8lgMLBikiwLVYQWYv4AsUphMCpFLI3U1Hl6F0ifB/hQyKsqhySgI7vi74dQQlYULEQIAhHmEABIuCEMBDAYAeAAQEJACjw0aZQEeBnmeliccDpoKh6anhA+kAAQEA6yur7EAqkKbsLKzs6O2Lbi4sgOvMH8LFqy5wsgAFYuMHcfJsgAbGH9CBxQchK3K1CtzSDEhqBUj100IGg4gICYYCOhHSktY9kdBADs%3D',
'data:image/gif;base64,R0lGODlhFAAUAKUCAEA0EP/mIP/////iHFVACPraEPbKAEAUEFlACPK2AP/eFP/eGPrWCPK+APrWDPLCAG1MBHFVBO6yAN6VAO6qAKVxBOadAP/aFPbGAOqhAPrOBPLGAOqqAMKNAKVpBM6NAK6BBLKNALp1AKp1BMqlAJlpBO6uAOaZAJVhBJ19BK6JBN6uAOalAK6FAOKVAM6FANalAMqFAJlxBN62ANauAP///////////////////////////////////////////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFRgA/ACwAAAAAFAAUAAAG0cCfcEgsGo0EAiKJOBYRERUNs4GBIgTnj5DSFL4OhiEhaxoRJMdlMRgsFg5Do2MeIkIOdmAAAAT6YyN1PxEabAN/AgIAigAPHBBDBHhtiY2KixIVZggzBZV9jKGLCR9ZWxufiKOsCROnBA8OiHuhtgYSr0IEKwx6AcDBCgwYHC+nCC0GqsHAAwVjGRWnhA3Lh3tsCg8ULpGSINYMBQBfYg0AFh7UQggdCQ8GBrbpIoN2JSwSCQkSFBkTULArQgBChQ8WTsTwAGHgkSQQHWqZKCQIACH5BAUKAD8ALAcABQAJAAYAAAYiwN8vEBgUDAbhgFhUMH7LJbFwZDILCgNgCwhwAUNpgPoLAgAh+QQFHgA/ACwHAAUACQAGAAAGG8DfDwAYFoUAgSC5HCqXTyJxOT3+qEmkVPoLAgAh+QQFCgA/ACwGAAUACgALAAAGLcDfDwAIEA0GIUAgWDYZQ2ZTCjAQl9emldjkVofXa0FILpvPaHNhPR6a0hRhEAAh+QQFMgA/ACwEAAUACwALAAAGOMDf73AYBAKDgvAHEAiOx4GC6XwaA4dCoUnEdgsK7gF6LFyGXfJ0yR6224f3Mv4m0htsg97wwP+CACH5BAEKAD8ALAQABQALAAsAAAY1wN9vMAAAfkbhsCgQAJrHQeAJbTqJxmf2OjU6vQBiN5sUBs7ogHKtHLDbRHahoCgIj2yyMAgAOw%3D%3D',
'data:image/gif;base64,R0lGODlhFAAUAMQAAP/mIFVACEA0EPbKAP/iHPK2AP/aEOqqAG1QBOaZAKVxBPLGAK6FAPraDPrSCPK+AO6yAP/eFPrWDP/eGFlACMqNAM6FAN6yANaqAJltBLp1APbOBJllAM6ZAAAAAAAAACH+HUJ1aWx0IHdpdGggR0lGIE1vdmllIEdlYXIgNC4wACH5BAkAAB4ALAAAAAAUABQAAAW6oCeOZGmaQaqeZYAw2LJgDBKwXqBskmFIjkEhczNROo3IhMCMNAaPCqXFMEwA2CzhWVAURQhHhAAQZM0Tx+KAGAUYEnL5DNgOIF5R4GKQm7F/BkIVRQELfVmJWBFCCYULEn+KWAYCEI56Fw6SigSbBxaFDAMNnFgElQUHeWAPpAJyBBOVDwcJbW4MrpsCvb0Pl6xuFQULA8cDC6oJGlMoGQcQBQUQB7YcXygIChYJCRYKNjhuKinj5yYhADs%3D');

if (Page == 'messages'){
var tds = xpaths('//table[@width="519"]/tbody/tr/td[@colspan="3"][@class="b"]');
for (var i = tds.snapshotLength - 1; i >= 0; i--){
var td = tds.snapshotItem(i);
for (var j = 17; j >= 0; j--){
while (td.innerHTML.indexOf(smilt[j]) != -1){
td.innerHTML = td.innerHTML.replace(smilt[j],'<img src="'+smilg[j]+'" alt="'+[j]+'" />');}}}}
if ((Page == 'allianzen') && (location.href.search(/a=17/) != -1) || (Page == 'writemessages')){
var textarea = xpath('//textarea[@name="text"]');
var smiltbl = textarea.parentNode.parentNode.childNodes[0];
smiltbl.innerHTML += '<br />'
for (var j = 17; j >= 0; j--){
smiltbl.innerHTML += '<img src="'+smilg[j]+'" title="'+smilt[j]+'" alt="'+smilt[j]+'" onclick="sofMsg_InsSml(\' '+smilt[j]+' \')" style="cursor:pointer" /> ';
if ((j == 6) || (j == 12)) smiltbl.innerHTML += '<br />';}}}

// ### OTHER ###

function sofSts_Diff(){
var self = xpath('//a[@href="#"][@style="color:lime;"]');
if (! self) return;
var poenitr = self.parentNode.parentNode.lastChild;
var poeni = DelCommas(poenitr.innerHTML);
if (poeni != 0){
var as = xpaths('//div[@id="content"]/center/table[@width="525"]/tbody/tr/th/a[contains(@onmouseover,"return overlib")]');
for (var i = as.snapshotLength - 1; i >= 0; i--){
var a = as.snapshotItem(i);
var tr = a.parentNode.parentNode;
var thnick = tr.childNodes[3];
var points = tr.childNodes[9];
var diff = AddCommas(DelCommas(points.innerHTML)-poeni);
thnick.innerHTML += '<br /><span style="color:orange;font-size:smaller">'+(diff > 0 ? '+'+diff : diff)+'</span>';}}}

function sofGen_LTime(){
var soGen_LTime = new Date() - soGen_LTimeS;
window.status = 'Runtime: '+soGen_LTime+' [ms]';}
